
#'
#' FirstObservation
#' 
#' FirstObservation is the raw data of DNE variables obtained from the first 
#' observation of the Southeast Asian sample. It consists of MeanDNE.Apex, MedianDNE.Apex, IQRDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole, MeanDNE.Convex, MeanDNE.Concave, Proportion.DNEunder0.0001 and Proportion.DNEover0.6.
#' 
#' @export
#' 
FirstObservation<-{
  MeanDNE.Apex <- c(0.019749, 0.033347, 0.024343, 0.015239, 0.023334, 0.013509, 0.019262, 0.021691, 0.019904, 0.019895, 0.023108, 0.022265, 0.020069, 0.025203, 0.026556, 0.025034, 0.019199, 0.031652, 0.025269, 0.020554, 0.023995, 0.026939, 0.029901, 0.03095, 0.017038, 0.029175, 0.027327, 0.025391, 0.028146, 0.032947, 0.02438, 0.021836, 0.023005, 0.026048, 0.029438, 0.02874, 0.024474, 0.021922, 0.019868, 0.027248, 0.028056, 0.024185, 0.0369, 0.029293, 0.028394, 0.03357, 0.030924, 0.036005, 0.047902, 0.018362, 0.03138, 0.034556, 0.032804, 0.030955, 0.024561, 0.016596, 0.032037, 0.03114, 0.031659, 0.038077, 0.018494, 0.022226,
                    0.045345, 0.042238, 0.039239, 0.034899, 0.033831, 0.038512, 0.043266, 0.021447, 0.031937, 0.041794, 0.021556, 0.040106, 0.039395, 0.045486, 0.034879, 0.033857, 0.030255, 0.028489, 0.05092, 0.048011, 0.030886, 0.035103, 0.043377, 0.031606, 0.049137, 0.039039, 0.02779, 0.040557, 0.048728, 0.044916, 0.03518, 0.034501, 0.038736, 0.020146, 0.033896, 0.040078, 0.020864, 0.028363, 0.040856, 0.023334, 0.036558, 0.040569, 0.055236, 0.022884, 0.02543, 0.053486, 0.042338, 0.048574, 0.028316, 0.051015, 0.039671, 0.046023, 0.029768, 0.053001, 0.040782, 0.046598, 0.043104, 0.058266, 0.047679, 0.051222, 0.053222, 0.051377, 0.067757, 0.038872, 0.036377, 0.051102, 0.034966, 0.064991, 0.063957, 0.054075, 0.044911, 0.05229, 0.059583, 0.046978, 0.058889, 0.045573, 0.048956, 0.050943)
  MedianDNE.Apex <- c(0.004763, 0.006146, 0.008214, 0.002086, 0.00539, 0.004026, 0.004725, 0.003719, 0.00517, 0.002588, 0.002738, 0.002328, 0.003047, 0.003106, 0.004206, 0.002866, 0.001816, 0.00303, 0.008348, 0.00354, 0.005629, 0.004055, 0.009305, 0.007396, 0.005892, 0.002733, 0.004027, 0.003342, 0.007788, 0.010469, 0.005289, 0.004081, 0.003805, 0.006078, 0.007423, 0.010448, 0.007887, 0.006334, 0.009468, 0.008223, 0.015704, 0.008618, 0.010204, 0.011762, 0.018738, 0.01039, 0.009855, 0.008116, 0.019265, 0.016915, 0.014042, 0.010131, 0.010513, 0.018552, 0.01061, 0.016206, 0.01352, 0.010132, 0.012759, 0.018493, 0.019736, 0.014556, 0.013505, 0.010459, 0.017919, 0.007674, 0.013471, 0.020248, 0.015323, 0.010233, 
                      0.016254, 0.009022, 0.011645, 0.011631, 0.00846, 0.016134, 0.008437, 0.010917, 0.009435, 0.010543, 0.015398, 0.016654, 0.015399, 0.015956, 0.012549, 0.017333, 0.021453, 0.009243, 0.011095, 0.021421, 0.009699, 0.012975, 0.010195, 0.016791, 0.010541, 0.010954, 0.011472, 0.011198, 0.012316, 0.008844, 0.017982, 0.007244, 0.014578, 0.013257, 0.009761, 0.014356, 0.012332, 0.019685, 0.024003, 0.014779, 0.012832, 0.011739, 0.023965, 0.012106, 0.021797, 0.021236, 0.015467, 0.019368, 0.011, 0.016182, 0.019931, 0.016823, 0.01007, 0.019207, 0.017616, 0.019071, 0.017189, 0.011478, 0.014415, 0.017244, 0.018609, 0.017022, 0.014024, 0.022836, 0.014933, 0.014751, 0.020165, 0.020211, 0.016836, 0.020813)
  IQRDNE.Apex <- c(0.013023, 0.019181, 0.022124, 0.011582, 0.015076, 0.009539, 0.016585, 0.018226, 0.014587, 0.015013, 0.016796, 0.016217, 0.014972, 0.014981, 0.016253, 0.022687, 0.014475, 0.018456, 0.016262, 0.014957, 0.015607, 0.014859, 0.017067, 0.01622, 0.016265, 0.017635, 0.01215, 0.023493, 0.021762, 0.020554, 0.020199, 0.021601, 0.014807, 0.024403, 0.019446, 0.017967, 0.021844, 0.019886, 0.021958, 0.017601, 0.020099, 0.02016, 0.026664, 0.020848, 0.017498, 0.020599, 0.025068, 0.021023, 0.026839, 0.021093, 0.024094, 0.027326, 0.022116, 0.023082, 0.025781, 0.024484, 0.020686, 0.023906, 0.022613, 0.031394, 0.016932, 0.020643, 0.031615, 0.025186, 0.040511, 0.03205, 0.024292, 0.026018, 0.018502, 0.036425, 0.033305, 0.021068, 0.020302, 0.021132, 0.034589, 0.030524, 0.018445, 0.022335, 0.021707, 
                   0.017659, 0.042665, 0.041422, 0.031384, 0.026645, 0.025706, 0.027396, 0.034456, 0.034147, 0.023289, 0.04258, 0.025684, 0.016012, 0.029732, 0.027165, 0.028149, 0.028563, 0.029887, 0.033043, 0.034107, 0.031466, 0.034101, 0.027679, 0.03656, 0.02576, 0.025902, 0.045187, 0.028784, 0.046078, 0.031061, 0.025892, 0.02141, 0.026978, 0.028198, 0.023661, 0.040691, 0.025813, 0.024506, 0.029153, 0.032177, 0.040032, 0.041014, 0.035713, 0.038987, 0.03922, 0.032081, 0.032716, 0.030249, 0.038948, 0.029493, 0.027651, 0.042335, 0.027394, 0.040764, 0.043256, 0.036249, 0.041752, 0.03991, 0.05424, 0.039111, 0.04609)
  TotalDNE.TotalPolygonFaces <- c(0.005891, 0.006252, 0.013529, 0.0071, 0.008151, 0.012751, 0.010276, 0.01138, 0.017543, 0.009855, 0.01537, 0.012995, 0.018234, 0.010017, 0.01418, 0.018144, 0.005413, 0.020804, 0.010309, 0.008285, 0.016405, 0.011259, 0.016231, 0.024452, 0.016517, 0.02051, 0.024024, 0.01921, 0.005445, 0.018394, 0.019373, 0.021051, 0.01237, 0.025627, 0.013634, 0.011224, 0.026345, 0.0103, 0.020463, 0.017374, 0.021069, 0.018316, 0.022521, 0.019607, 0.025849, 0.01868, 0.015123, 0.02116, 0.020851, 0.026525, 0.021317, 0.020383, 0.0263, 0.013409, 0.023262, 0.021041, 0.01373, 0.021641, 0.01105, 0.028594, 0.023392, 0.019048, 0.016276, 0.013861, 0.023586, 0.014906, 0.022047, 0.015837, 0.022468, 0.019467, 0.020714, 0.020399, 0.032485, 0.030867, 0.021141, 0.021737, 0.023905, 0.025735, 0.023698, 0.027583, 0.035175, 0.027194, 0.017308, 0.017171, 0.024821, 0.026291, 0.020435,
                                  0.024041, 0.021606, 0.021717, 0.005321, 0.008533, 0.021342, 0.026256, 0.024835, 0.026569, 0.023447, 0.010535, 0.024783, 0.027821, 0.040965, 0.026731, 0.028904, 0.019027, 0.031761, 0.021576, 0.02891, 0.018761, 0.03409, 0.019858, 0.044709, 0.023778, 0.023386, 0.036887, 0.02945, 0.026846, 0.026255, 0.035643, 0.040524, 0.033858, 0.04419, 0.047067, 0.035632, 0.041644, 0.037988, 0.020316, 0.042967, 0.037647, 0.025351, 0.026846, 0.046261, 0.045152, 0.037833, 0.047493, 0.038935, 0.029461, 0.052655, 0.036279, 0.034663, 0.037826)
  MedianDNE.Whole <- c(0.00241, 0.004163, 0.005258, 0.010567, 0.004286, 0.007416, 0.005235, 0.005595, 0.002925, 0.004263, 0.006905, 0.004463, 0.005573, 0.006488, 0.007009, 0.00265, 0.004247, 0.008562, 0.005107, 0.004992, 0.005214, 0.006434, 0.009039, 0.005922, 0.00539, 0.003054, 0.005094, 0.008632, 0.004626, 0.00759, 0.006309, 0.004514, 0.002973, 0.008235, 0.006476, 0.005287, 0.00528, 0.00306, 0.002032, 0.005795, 0.008982, 0.009408, 0.00417, 0.00895, 0.007558, 0.005596, 0.004559, 0.010221, 0.005359, 0.004513, 0.00768, 0.004382, 0.005967, 0.007414, 0.004685, 0.002552, 0.005089, 0.008234, 0.004243, 0.01386, 0.005199, 0.00493, 0.004176, 0.010676, 0.011688, 0.007848, 0.008571, 0.009557, 0.012036, 0.010368, 0.011969, 0.004072, 
                       0.010032, 0.007663, 0.007199, 0.009055, 0.005674, 0.007179, 0.008563, 0.003595, 0.009133, 0.009333, 0.008861, 0.009874, 0.011738, 0.007882, 0.014061, 0.007768, 0.010514, 0.014225, 0.010107, 0.008239, 0.012693, 0.007186, 0.012605, 0.009354, 0.014141, 0.008768, 0.004969, 0.010477, 0.012346, 0.004602, 0.011925, 0.011616, 0.004308, 0.013978, 0.011542, 0.014869, 0.009323, 0.009293, 0.011481, 0.012951, 0.009951, 0.004691, 0.007243, 0.014117, 0.011272, 0.01354, 0.010476, 0.012555, 0.01346, 0.010981, 0.015997, 0.012388, 0.012051, 0.013764, 0.01239, 0.011098, 0.007946, 0.017589, 0.013927, 0.009536, 0.009773, 0.00967, 0.011495, 0.012406, 0.01225, 0.014609, 0.010668, 0.010095)
  IQRDNE.Whole <- c(0.007612, 0.011803, 0.00714, 0.005213, 0.009494, 0.0132, 0.006966, 0.009043, 0.00777, 0.009416, 0.011022, 0.008735, 0.009929, 0.010475, 0.011728, 0.019951, 0.007833, 0.01767, 0.014034, 0.017824, 0.010905, 0.00871, 0.015172, 0.00692, 0.009053, 0.01019, 0.010336, 0.010708, 0.007518, 0.006442, 0.012336, 0.016615, 0.014407, 0.01844, 0.019315, 0.018683, 0.014908, 0.021165, 0.018199, 0.013157, 0.013404, 0.015042, 0.021072, 0.012421, 0.020508, 0.012317, 0.013299, 0.013661, 0.028764, 0.01022, 0.014346, 0.011297, 0.016502, 0.008244, 0.017902, 0.014382, 0.013683, 0.015856, 0.014885, 0.024412, 0.025767, 0.018097, 0.021784, 0.017937, 0.012553, 0.01116, 0.017831, 0.021226, 0.01811, 0.007118, 0.021659, 0.011555, 0.026439, 0.019879, 0.017704, 0.0246, 0.024536, 0.023908, 0.02161, 0.02187, 0.029267, 
                    0.014327, 0.02439, 0.019979, 0.023059, 0.023179, 0.019703, 0.021013, 0.024877, 0.023725, 0.017556, 0.023746, 0.021298, 0.015469, 0.020161, 0.017528, 0.032493, 0.02693, 0.014823, 0.024408, 0.028706, 0.024298, 0.027758, 0.022095, 0.02663, 0.020694, 0.026932, 0.020035, 0.025636, 0.020802, 0.02722, 0.017819, 0.027366, 0.032521, 0.023696, 0.023285, 0.025407, 0.031468, 0.029251, 0.027214, 0.032442, 0.032504, 0.031342, 0.031057, 0.041657, 0.024486, 0.03166, 0.031364, 0.024197, 0.024871, 0.035243, 0.026807, 0.032395, 0.022188, 0.025875, 0.027537, 0.036971, 0.022341, 0.02453, 0.037298)
  MeanDNE.Convex <- c(0.012092, 0.01593, 0.01366, 0.012868, 0.014622, 0.010956, 0.015727, 0.012565, 0.017104, 0.013965, 0.015969, 0.012886, 0.013971, 0.017258, 0.014692, 0.010357, 0.014716, 0.020492, 0.019854, 0.01837, 0.015016, 0.017436, 0.020316, 0.016337, 0.018101, 0.016674, 0.021796, 0.013328, 0.018878, 0.016904, 0.020296, 0.014809, 0.015178, 0.020729, 0.019411, 0.018215, 0.02063, 0.019437, 0.018647, 0.013067, 0.016929, 0.018398, 0.014945, 0.016274, 0.024728, 0.01787, 0.016379, 0.016364, 0.024026, 0.022037, 0.025629, 0.012373, 0.018284, 0.020119, 0.018067, 0.017206, 0.020081, 0.015919, 0.020834, 0.019198, 0.017281, 
                      0.021369, 0.017115, 0.017048, 0.021889, 0.01704, 0.016795, 0.02062, 0.024514, 0.017528, 0.017207, 0.020766, 0.019014, 0.018615, 0.01623, 0.02253, 0.023044, 0.020323, 0.018936, 0.017476, 0.021426, 0.021439, 0.018135, 0.021251, 0.02134, 0.020207, 0.022237, 0.025414, 0.01849, 0.02015, 0.021198, 0.025391, 0.024098, 0.029544, 0.021234, 0.021477, 0.023424, 0.021407, 0.020171, 0.019289, 0.020448, 0.021517, 0.016872, 0.020644, 0.017426, 0.02303, 0.024055, 0.016294, 0.020287, 0.023358, 0.019647, 0.026618, 0.022845, 0.028379, 0.024804, 0.02408, 0.023264, 0.026163, 0.02086, 0.021321, 0.027668, 0.029683, 0.025381, 0.02553, 0.028451, 0.021788, 0.033171, 0.026394, 0.022692, 0.024348, 0.029684, 0.032356, 0.028985, 0.036171, 0.02698, 0.029734, 0.030235, 0.024592, 0.027385, 0.028419)
  MeanDNE.Concave <- c(0.009558, 0.015024, 0.010862, 0.009581, 0.010692, 0.010883, 0.010968, 0.011434, 0.013745, 0.011386, 0.015813, 0.010081, 0.010027, 0.017756, 0.014176, 0.020545, 0.015658, 0.017322, 0.017622, 0.012399, 0.018855, 0.012492, 0.015437, 0.014466, 0.018356, 0.015908, 0.02117, 0.015202, 0.012233, 0.017358, 0.020288, 0.015078, 0.015906, 0.015128, 0.010928, 0.020603, 0.01744, 0.019176, 0.016018, 0.014564, 0.016392, 0.030405, 0.015651, 0.019966, 0.020739, 0.015972, 0.01711, 0.023923, 0.025357, 0.027692, 0.01762, 0.02586, 0.025279, 0.020662, 0.014946, 0.022048, 0.021872, 0.021395, 0.022162, 0.02844, 0.02022, 0.015469, 0.018047, 0.01339, 0.015646, 0.01643, 0.022897, 0.012528, 0.018781, 0.021382, 0.016036, 0.020092, 0.025289, 0.021251, 0.017346, 0.024155, 0.02611, 0.022277, 0.020159, 
                       0.01859, 0.029079, 0.030863, 0.021849, 0.02115, 0.025056, 0.014556, 0.031014, 0.03591, 0.029743, 0.028014, 0.02574, 0.032297, 0.018405, 0.021683, 0.030507, 0.029183, 0.014871, 0.025065, 0.021675, 0.031235, 0.031396, 0.032122, 0.035, 0.031686, 0.031304, 0.030255, 0.031436, 0.020547, 0.027611, 0.020975, 0.03171, 0.015798, 0.030413, 0.0375, 0.030449, 0.029746, 0.032876, 0.025741, 0.032368, 0.032033, 0.031712, 0.031925, 0.031858, 0.029177, 0.030538, 0.027481, 0.036156, 0.031874, 0.023425, 0.039702, 0.037204, 0.029948, 0.028114, 0.043048, 0.029007, 0.027969, 0.03212, 0.034946, 0.033331, 0.035245)
  Proportion.DNEunder0.0001 <- c(0.007312, 0.007134, 0.008959, 0.009721, 0.006349, 0.009168, 0.007964, 0.005258, 0.005775, 0.006678, 0.006973, 0.007623, 0.006332, 0.008929, 0.008322, 0.006096, 0.008017, 0.005073, 0.004059, 0.009951, 0.007644, 0.009156, 0.007878, 0.008455, 0.005, 0.006818, 0.007053, 0.005416, 0.004913, 0.005997, 0.008645, 0.00762, 0.006254, 0.005239, 0.007597, 0.005619, 0.009209, 0.008893, 0.004906, 0.007008, 0.006472, 0.005013, 0.007211, 0.005193, 0.007333, 0.007565, 0.006914, 0.004328, 0.004872, 0.004551, 0.004704, 0.005722, 0.00547, 0.005146, 0.005099, 0.008946, 0.005123, 0.005396, 0.006356, 0.006982, 0.004192, 0.004605, 0.004923, 0.008392, 0.007322, 0.004631, 0.006412, 0.007097, 0.005642, 0.006807, 0.003503, 0.005293, 0.006508, 0.005903, 0.004832, 0.005368, 0.005609, 0.00454, 0.003169, 0.003054, 0.005333, 0.004357, 0.004298, 0.004752, 0.002988, 
                                 0.005773, 0.004671, 0.002747, 0.003262, 0.002989, 0.003216, 0.005966, 0.002419, 0.003167, 0.005914, 0.004349, 0.002331, 0.002189, 0.003513, 0.006787, 0.002937, 0.00391, 0.003094, 0.00427, 0.005877, 0.006782, 0.002677, 0.003741, 0.002737, 0.004645, 0.001995, 0.003204, 0.003824, 0.004149, 0.003432, 0.003148, 0.003354, 0.003892, 0.004799, 0.004318, 0.003758, 0.00463, 0.00431, 0.003148, 0.002944, 0.004224, 0.002437, 0.003581, 0.002478, 0.002073, 0.002539, 0.003916, 0.003192, 0.002104, 0.002865, 0.00493, 0.002488, 0.003432, 0.002331, 0.002548) 
  Proportion.DNEover0.6 <- c(0.000496, 0.000742, 0.000247, 0.001009, 0.000689, 0.000157, 0.000435, 0.001057, 0.000565, 0.000422, 0.000976, 0.000466, 0.000367, 0.001581, 0.000775, 0.002184, 0.001007, 0.001852, 0.001081, 0.001168, 0.000483, 0.000378, 0.000727, 0.000925, 0.000759, 0.000521, 0.000451, 0.001485, 0.000596, 0.000904, 0.000396, 0.001097, 0.000523, 0.000386, 0.000402, 0.000417, 0.000515, 0.000478, 0.00113, 0.00045, 0.001245, 0.001621, 0.000609, 0.002257, 0.001349, 0.001747, 0.001445, 0.001517, 0.001376, 0.001908, 0.001879, 0.001059, 0.002664, 0.001443, 0.002308, 0.001699, 0.001384, 0.000703, 0.000891, 0.002234, 0.002024, 0.000464, 0.001453, 0.002031, 0.001906, 0.0021, 0.001098, 0.000339, 0.002287, 0.001314, 0.001141, 0.001975, 0.002309, 0.001654, 0.001602, 0.001482, 0.00145, 
                             0.00145, 0.001529, 0.002006, 0.001009, 0.001221, 0.002818, 0.001283, 0.002413, 0.001182, 0.001273, 0.002434, 0.002181, 0.001188, 0.002017, 0.002394, 0.002145, 0.002763, 0.002132, 0.002151, 0.002075, 0.001956, 0.001054, 0.002496, 0.001608, 0.001979, 0.002118, 0.001553, 0.00237, 0.002931, 0.002297, 0.001442, 0.003439, 0.001409, 0.00133, 0.001191, 0.001507, 0.001665, 0.002263, 0.001603, 0.003063, 0.001092, 0.002923, 0.001785, 0.002045, 0.001464, 0.002173, 0.001919, 0.004439, 0.001146, 0.004085, 0.002645, 0.001938, 0.003586, 0.003344, 0.001261, 0.002575, 0.002192, 0.003088, 0.002415, 0.001801, 0.001652, 0.002332, 0.004038)
  FirstObservation <- data.frame(MeanDNE.Apex, MedianDNE.Apex, IQRDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole, MeanDNE.Convex, MeanDNE.Concave, Proportion.DNEunder0.0001, Proportion.DNEover0.6)
  FirstObservation
}

#' @examples 
#' FirstObservation