% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmcsB.R
\name{jmcsB}
\alias{jmcsB}
\title{Joint model for Bidirectional survival data using \code{FastJM}}
\usage{
jmcsB(
  dtlong,
  dtsurv,
  longm,
  survm,
  rd,
  id,
  timeVar,
  BIGdata = FALSE,
  samplesize = 200
)
}
\arguments{
\item{dtlong}{longitudinal data}

\item{dtsurv}{survival data with two event status along with event time}

\item{longm}{longitudinal model e.g. list(serBilir~drug * year,serBilir ~ drug * year)}

\item{survm}{survival model e.g. list(Surv(years,status2)~drug,Surv(time_2,status_2)~drug+age)}

\item{rd}{random effect component e.g. list(~year|id,~year|id)}

\item{id}{ID variable}

\item{timeVar}{time variable}

\item{BIGdata}{logical argument TRUE or FALSE}

\item{samplesize}{samplesize for bigdata}
}
\value{
Estimated model parameters of Joint model with bidirectional survival data
}
\description{
The function fits joint model for survival data with two events. It utilizes the FastJM package for obtaining the model parameter estimates.
}
\examples{
library(FastJM)
library(JMbayes2)
st_pbcid<-function(){
  new_pbcid<-pbc2.id
  new_pbcid$time_2<-rexp(n=nrow(pbc2.id),1/10)
  cen_time<-runif(nrow(pbc2.id),min(new_pbcid$time_2),max(new_pbcid$time_2))
  status_2<-ifelse(new_pbcid$time_2<cen_time,1,0)
  new_pbcid$status_2<-status_2
  new_pbcid$time_2<-ifelse(new_pbcid$time_2<cen_time,new_pbcid$time_2,cen_time)
  new_pbcid$time_2<-ifelse(new_pbcid$time_2<new_pbcid$years,new_pbcid$years,new_pbcid$time_2)
  new_pbcid
}
new_pbc2id<-st_pbcid()
pbc2$status_2<-rep(new_pbc2id$status_2,times=data.frame(table(pbc2$id))$Freq)
pbc2$time_2<-rep(new_pbc2id$time_2,times=data.frame(table(pbc2$id))$Freq)
pbc2_new<-pbc2[pbc2$id\%in\%c(1:50),]
new_pbc2id<-new_pbc2id[new_pbc2id$id\%in\%c(1:50),]
model_jmcs<-jmcsB(dtlong=pbc2_new,dtsurv=new_pbc2id,
                  longm=list(serBilir~drug*year,
                             serBilir~drug*year),
                  survm=list(Surv(years,status2)~drug,
                             Surv(time_2,status_2)~drug+age),
                  rd=list(~1|id,~1|id),
                  id='id',timeVar='year')
model_jmcs
}
\references{
Li, Shanpeng, et al. "Efficient Algorithms and Implementation of a Semiparametric Joint Model for Longitudinal and Competing Risk Data: With Applications to Massive Biobank Data." Computational and Mathematical Methods in Medicine 2022 (2022).

  Bhattacharjee, A., Rajbongshi, B. K., & Vishwakarma, G. K. (2024). jmBIG: enhancing dynamic risk prediction and personalized medicine through joint modeling of longitudinal and survival data in big routinely collected data. BMC Medical Research Methodology, 24(1), 172.
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
