% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_functions.R
\name{find_peak_boundaries}
\alias{find_peak_boundaries}
\title{find_peak_boundaries}
\usage{
find_peak_boundaries(
  int = NULL,
  p = which.max(int),
  k = 3,
  min_scans = 3,
  noise = 0
)
}
\arguments{
\item{int}{Numeric vector (of intensity values).}

\item{p}{Index of peak position (usually 'which.max(int)).}

\item{k}{Number of scans at peak boarder to confirm peak valley.}

\item{min_scans}{Minimum number of scans in front or tail.}

\item{noise}{A threshold value. All Values below or equal to noise will be set to zero.}
}
\value{
A numeric vector of length 2 giving the indexes of peak start and peak end.
}
\description{
\code{find_peak_boundaries} will find the start and end point
of a peak based on curve derivative.
}
\details{
This function provides a simple detection algorithm for peak boundaries.
It will accept a numeric vector as input and determine relative to the global maximum
(or a user provided local maximum) the left and right border where intensity decrease
ends and intensity is increasing again.
}
\examples{
\dontrun{
x <- sin(seq(-pi,2*pi,0.01))+1
plot(x)
abline(v=find_peak_boundaries(x))
}
}
