% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-apply.R
\docType{methods}
\name{apply}
\alias{apply}
\alias{apply,IntervalMatrix-method}
\title{Apply functions over \code{IntervalMatrix} margins}
\usage{
\S4method{apply}{IntervalMatrix}(X, MARGIN, FUN)
}
\arguments{
\item{X}{A matrix of interval-valued data stored as
an \code{IntervalMatrix} object.}

\item{MARGIN}{A single numeric value giving the direction which the function
will be applied over. In this case, only two different options
are allowed:
\itemize{
\item \code{1}: The function will be applied by rows.
\item \code{2}: The function will be applied by columns.
}}

\item{FUN}{The function to be applied over the selected interval-valued
matrix margins.}
}
\value{
This function returns the numeric vector or the list of interval-valued data
attained by applying the selected function to the specified margin (rows or
columns) of an interval-valued matrix. Therefore, this function always
returns either a \code{numeric} or either an \code{IntervalList} object,
respectively.
}
\description{
This function allows to apply a function over the
rows or columns of an interval-valued matrix.
}
\examples{
## Some apply() examples
## IntervalMatrix definition
m <- IntervalMatrix(matrix(c(0, 1, 2, 3, 0, 3, 4, 9), 2, 4))
## Calculate sample Aumann means by rows and columns
## These code lines return IntervalList objects
apply(m, 1, mean)
apply(m, 2, mean)
## Calculate sample Fréchet variance by rows and columns
## These code lines return numeric vectors
apply(m, 1, var)
apply(m, 2, var)
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
