% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sld.R
\name{sld}
\alias{sld}
\title{Simple Longitudinal Difference (SLD)}
\usage{
sld(data, subject_id, time, response, k = 2, verbose = FALSE)
}
\arguments{
\item{data}{A data frame containing longitudinal data.}

\item{subject_id}{A column specifying the column name for subject IDs.}

\item{time}{A column specifying different time points that observations are measured.}

\item{response}{A column specifying the column name for the response variable.}

\item{k}{A numeric value for the threshold parameter (default is 2), representing the number of standard deviations used to define the threshold.}

\item{verbose}{Logical; if TRUE, prints informative messages during execution.}
}
\value{
A list containing:
\item{influential_subjects}{A vector of subject IDs identified as influential.}
\item{influential_data}{A data frame containing data for influential subjects.}
\item{non_influential_data}{A data frame containing data for non-influential subjects.}
\item{successive_difference_plot}{A ggplot object visualizing maximum successive differences across subjects.}
\item{longitudinal_plot}{A ggplot object displaying longitudinal data with influential subjects highlighted.}
\item{IS_table}{A data frame containing the Influence Score (IS) and the Partial Influence Score (PIS) values for each subject at each time point.}
}
\description{
This function detects influential subjects in a longitudinal dataset by analyzing their successive differences.
It calculates the successive differences for each subject, determines a threshold using the mean and standard deviation,
and identifies subjects whose maximum successive difference exceeds this threshold. This approach helps in detecting abrupt changes
in subject responses over time.
}
\details{
The function follows these steps:
\itemize{
  \item Computes successive differences for each subject.
  \item Calculates the mean and standard deviation of these differences across all subjects.
  \item Defines a threshold as \code{k} standard deviations from the mean.
  \item Identifies subjects whose maximum successive difference exceeds this threshold.
  \item Separates data into influential and non-influential subjects.
  \item Visualizes the results using \code{ggplot2}.
}

This method is useful for identifying subjects with sudden changes in their response patterns over time.
}
\examples{
data(infsdata)
infsdata <- infsdata[1:5,]
result <- sld(infsdata, "subject_id", "time", "response", k = 2)
print(result$influential_subjects)
head(result$influential_data)
head(result$non_influential_data)

}
\seealso{
tvm, wlm, slm, rld
}
