% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVC.R
\name{IVC}
\alias{IVC}
\title{Integrated Variance Correlation}
\usage{
IVC(y, x, K, NN = 3, type)
}
\arguments{
\item{y}{is a numeric vector}

\item{x}{is a numeric vector or a data matrix}

\item{K}{is the number of quantile levels}

\item{NN}{is the number of B spline basis, default is 3}

\item{type}{is an indicator for measuring linear or nonlinear correlation, "linear" represents linear correlation and "nonlinear" represents linear or nonlinear correlation using B splines}
}
\value{
The value of the corresponding sample statistic
}
\description{
This function is used to calculate the integrated variance correlation between two random variables or between a random variable and a multivariate random variable
}
\examples{
# linear model
n=100
x=rnorm(n)
y=3*x+rnorm(n)

IVC(y,x,K=5,type="linear")
# nonlinear model
n=100
p=3
x=matrix(NA,nrow=n,ncol=p)
for(i in 1:p){
 x[,i]=rnorm(n)
}
y=cos(x[,1]+x[,2])+x[,3]^2+rnorm(n)
IVC(y,x,K=5,type="nonlinear")
}
