% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comtradrclean_function.R
\name{Comtradrclean}
\alias{Comtradrclean}
\title{Comtradr data clean}
\usage{
Comtradrclean(DF, YEAR, threshold, cutoff)
}
\arguments{
\item{DF}{Dataframe of trade data downloaded (potentially using the comtradr package)}

\item{YEAR}{Year}

\item{threshold}{Apply a threshold - TRUE, Extract the backbone - FALSE}

\item{cutoff}{Threshold - cutoff level, Backbone - significance level}
}
\value{
International Trade Network - igraph object
}
\description{
This function takes (import) trade data downloaded from comtrade - potentially using the comtradr package, cleans it and transforms it into a network.
Adding a number of country level attributes to nodes in the network, including: regional partition, GDP, GDP per capita, GDP growth and FDI.
However, it is important to note the limits of using comtradr to construct a network.
Firstly when downloading the data with comtradr, you must specify reporters and partners –
yet you cannot put “all” for both – only for either reporters or partners.
Then for the other you are limited to a character vector of country names,
length five or fewer. Therefore, this will not give you a full network.
However, this function can be applied to trade data downloaded from UN Comtrade (download csv and read into R as a dataframe), or any other trade data. You just make sure it has the following column names:
reporter_iso, partner_iso, trade_value_usd and year. Some dataformats may have different names. Also - it is important to note that this function is for import data.
}
