% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fall_enroll2020}
\alias{fall_enroll2020}
\title{Fall Enrollment 2020 Data}
\format{
A data frame of 6129 rows representing institutions and 31 variables

\describe{
\item{INSTITUTION_ID}{Unique identification number of the institution}
\item{ENROLL}{Grand total}
\item{M_ENROLL}{Grand total men}
\item{W_ENROLL}{Grand total women}
\item{NATIVE_ENROLL}{American Indian or Alaska Native total}
\item{NATIVE_M_ENROLL}{American Indian or Alaska Native men}
\item{NATIVE_W_ENROLL}{American Indian or Alaska Native women}
\item{ASIAN_ENROLL}{Asian total}
\item{ASIAN_M_ENROLL}{Asian men}
\item{ASIAN_W_ENROLL}{Asian women}
\item{BLACK_ENROLL}{Black or African American total}
\item{BLACK_M_ENROLL}{Black or African American men}
\item{BLACK_W_ENROLL}{Black or African American women}
\item{LATINX_ENROLL}{Hispanic total}
\item{LATINX_M_ENROLL}{Hispanic men}
\item{LATINX_W_ENROLL}{Hispanic women}
\item{PAC_ISL_ENROLL}{Native Hawaiian or Other Pacific Islander total}
\item{PAC_ISL_M_ENROLL}{Native Hawaiian or Other Pacific Islander men}
\item{PAC_ISL_W_ENROLL}{Native Hawaiian or Other Pacific Islander women}
\item{WHITE_ENROLL}{White total}
\item{WHITE_M_ENROLL}{White men}
\item{WHITE_W_ENROLL}{White women}
\item{MULT_RACE_ENROLL}{Two or more races total}
\item{MULT_RACE_M_ENROLL}{Two or more races men}
\item{MULT_RACE_W_ENROLL}{Two or more races women}
\item{UNKNOWN_RACE_ENROLL}{Race/ethnicity unknown total}
\item{UNKNOWN_RACE_M_ENROLL}{Race/ethnicity unknown men}
\item{UNKNOWN_RACE_W_ENROLL}{Race/ethnicity unknown women}
\item{IMMIGRANT_ENROLL}{Nonresident alien total}
\item{IMMIGRANT_M_ENROLL}{Nonresident alien men}
\item{IMMIGRANT_W_ENROLL}{Nonresident alien women}
}
}
\source{
Download from Integrated Postsecondary Education Data System,
\url{https://nces.ed.gov/ipeds/datacenter/data/EF2020A.zip}.
}
\usage{
fall_enroll2020
}
\description{
This file contains the number of students enrolled in the fall, by race/ethnicity, gender, attendance (full- or part-time) status and level of student.  Institutions with traditional academic year calendar systems (semester, quarter, trimester or  4-1-4) report their enrollment as of October 15 or the official fall reporting date of the institution. Institutions with calendar systems that differ by program or allow continuous enrollment report students that are enrolled at any time between August 1 and October 31. This file has multiple records per institution.  Records are uniquely defined by the variables IPEDS ID (UNITID), and the attendance status and level of student (EFALEVEL).   Each record will contain the total enrollment,  enrollment for men and women, and the total enrollment and enrollment for men and women for all nine race/ethnicity categories.
}
\details{
Provisional release data have undergone all NCES data quality control procedures. Data are imputed for nonresponding institutions.
}
\keyword{datasets}
