% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.getKM.R
\name{summary.getKM}
\alias{summary.getKM}
\title{Print the summary of the IPD estimation}
\usage{
\method{summary}{getKM}(object, ...)
}
\arguments{
\item{object}{the object returned by other functions.}

\item{...}{ignored arguments}
}
\description{
Generate descriptive summary for objects returned by other functions\cr\cr
}
\details{
\code{summary()} prints the objects returned by other functions.
}
\examples{

# Radiationdata$radio is a dataset exported from ScanIt software ================
radio <- Radiationdata$radio

# Load time points when the patients number =========
# at risk reported (i.e. trisk in month) =========
trisk <- Radiationdata$trisk

# Load the numbers of patients at risk reported (i.e. nrisk) ======
# at the time points (trisk) ========
nrisk.radio <- Radiationdata$nrisk.radio

# Use the trisk and nrisk as input for preprocess and reconstruction ============
pre_radio_1 <- preprocess(dat=Radiationdata$radio, trisk=trisk,
             nrisk=nrisk.radio,totalpts=NULL,maxy=100)
est_radio_1 <- getIPD(prep=pre_radio_1,armID=0,tot.events=NULL)

# Output include reconstructed individual patients data =========================
head(est_radio_1$IPD)
summary(est_radio_1)

# When trisk and nrisk were not available, then we must input ====================
# the initial number of patients ===============================================
pre_radio_2 <- preprocess(dat=Radiationdata$radio, totalpts=213,maxy=100)
est_radio_2 <- getIPD(prep=pre_radio_2,armID=0,tot.events=NULL)

# Output include reconstructed individual patients data ==========================
head(est_radio_2$IPD)
summary(est_radio_2)


}
\references{
Guyot P, Ades AE, Ouwens MJ, Welton NJ. Enhanced secondary analysis of survival data: reconstructing the data from published Kaplan-Meier survival curves. BMC Med Res Methodol.2012; 1:9.
}
