% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadator.R
\name{downloadator}
\alias{downloadator}
\title{Downloads the latest version of blended data from the ECA&D website}
\usage{
downloadator(
  homefolder = "../ecad_updated",
  tx = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_tx.zip",
  tx2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_tx.txt",
  tn = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_tn.zip",
  tn2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_tn.txt",
  tg = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_tg.zip",
  tg2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_tg.txt",
  sd = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_sd.zip",
  sd2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_sd.txt",
  ss = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_ss.zip",
  ss2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_ss.txt",
  rr = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_rr.zip",
  rr2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_rr.txt",
  pp = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_pp.zip",
  pp2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_rr.txt",
  cc = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_cc.zip",
  cc2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_cc.txt",
  hu = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_hu.zip",
  hu2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_hu.txt",
  fg = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_fg.zip",
  fg2 = "http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_fg.txt"
)
}
\arguments{
\item{homefolder}{full path to local folder in the form './homefolder'. The function will store there the station files and create ./homefolder/raw
and will store there the data}

\item{tx}{link to download daily maximum temperature or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{tx2}{link to download daily maximum temperatures station list  or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{tn}{link to download daily minimum temperature or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{tn2}{link to download daily minimum temperature station list or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{tg}{link to download daily average temperature or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{tg2}{link to download daily average temperature station list or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{sd}{link to download daily snow depth or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{sd2}{link to download daily snow depth station list or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{ss}{link to download daily sunshine duration or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{ss2}{link to download daily sunshine duration station list or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{rr}{link to download daily rainfall or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{rr2}{link to download daily rainfall station list or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{pp}{link to download daily sea level pressure or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{pp2}{link to download daily sea level pressure station list or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{cc}{link to download daily cloud coverage or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{cc2}{link to download daily cloud coverage station list or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{hu}{link to download daily relative humidity or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{hu2}{link to download daily relative humidity station list or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{fg}{link to download daily wind speed or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}

\item{fg2}{link to download daily wind speed station list or NULL. Default set to working ECA&D link, as of 22/12/2020. Provided link MUST exist.}
}
\value{
For each valid link, the corresponding file will be downloaded. Data files will be unzipped to the ./raw folder (as requested by INQC)
and station files will be stored at the specified homefolder
}
\description{
This function will use the default or specified links to download one or several files from ECA&D and place them for their use
with INQC. For each variable a data file and a station file will/should be specified.
}
\examples{
\dontrun{
#Set a temporal working directory:
wd <- tempdir()
wd0 <- setwd(wd)
#Please note, the command below might take a while and will download the ECA&D data
#with a size more than 0.5GB
downloadator('./data',
             tx=NULL,
             tx2=NULL,
             tn=NULL,
             tn2=NULL,
             tg=NULL,
             tg2=NULL,
             sd=NULL,
             sd2=NULL,
             ss='http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_nonblend_ss.zip',
             ss2="http://knmi-ecad-assets-prd.s3.amazonaws.com/download/ECA_blend_source_ss.txt",
             rr=NULL,
             rr2=NULL,
             pp=NULL,
             pp2=NULL,
             cc=NULL,
             cc2=NULL,
             hu=NULL,
             hu2=NULL,
             fg=NULL,
             fg2=NULL)
#Delete the downloaded archive (the zip-file)
file.remove(paste(wd,"/data/raw/","ss.zip",sep=""))
#Return to user's working directory:
setwd(wd0)
#The downloaded files can be found in directory:
print(wd)
}
}
