% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.qcs.R
\name{k.qcs}
\alias{k.qcs}
\alias{k.qcs.default}
\alias{k.qcs.lab.qcdata}
\title{Function to calcute the Mandel's k statistic}
\usage{
k.qcs(x, ...)

\method{k.qcs}{default}(
  x,
  var.index = 1,
  replicate.index = 2,
  material.index = 3,
  laboratory.index = 4,
  data.name = NULL,
  alpha = 0.05,
  ...
)

\method{k.qcs}{lab.qcdata}(x, alpha = 0.05, ...)
}
\arguments{
\item{x}{An object of class \code{lab.qcdata} (Univariate Quality Control Data).}

\item{...}{Other arguments passed to or from methods.}

\item{var.index}{A scalar with the column number corresponding to the observed variable (the critical to quality variable).
Alternativelly can be a string with the name of the quality variable.}

\item{replicate.index}{A scalar with the column number corresponding to the index each replicate.}

\item{material.index}{A scalar corresponding to the replicated number.}

\item{laboratory.index}{A scalar that defines the index number of each laboratory.}

\item{data.name}{A string specifying the name of the variable which appears on the plots.
If name is not provided, it is taken from the object given as data.}

\item{alpha}{The significance level (0.05 by default)}
}
\description{
This function is used to compute the statistic k of Mandel.
}
\examples{

library(ILS)
data(Glucose)
Glucose.qcdata <- lab.qcdata(Glucose)
str(Glucose.qcdata)
k<- k.qcs(Glucose.qcdata, alpha = 0.005)
summary(k)
plot(k)
}
\references{
Wilrich Peter-T. (2013),  Critical values of Mandel's h and k,
the Grubbs and the Cochran test statistic. Asta-Advances in Statistical Analysis, 97(1):1-10.

ASTM E 691 (1999), Standard practice for conducting an interlaboratory study
to determine the precision of a test method. American Society for Testing and Materials. West Conshohocken, PA, USA.
}
