% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateMultivariate.R
\name{GenerateMultivariate}
\alias{GenerateMultivariate}
\title{Generate dataset with multiple individual identity traits}
\usage{
GenerateMultivariate(nindivs, nobs, nvars, covar, individuality)
}
\arguments{
\item{nindivs}{Indicates how many individuals should be in dataset}

\item{nobs}{Indicates how many observations per individual should be in
dataset}

\item{nvars}{Indicates how many trait variables should be in dataset.}

\item{covar}{Indicates covariance between variables in dataset. covar=0 for
uncorrelated variables; covar=1 for fully correlated variables}

\item{individuality}{Indicates the ratio of between to within individual
variation in each trait variable.}
}
\value{
Data frame with the identity codes in the first column and trait
  variables in subsequent columns. Number of rows and columns depends on the
  parameters used to generate dataset.
}
\description{
This functions generates a dataset with desired parameters (number of
individuals and number of observations per individual, number of variables
and covariance between variables, individuality). Unlike for the function
\code{GenerateUnivariate}, trait means are not customizable and are always set to 0.
}
\examples{
id1 <- GenerateMultivariate(nindivs=10, nobs=10, nvars=2, covar=0, individuality=1)

}
\seealso{
Other Operations with datasets: \code{\link{GenerateUnivariate}}
}
\concept{Operations with datasets}
