% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICV.R
\name{h_isemixnorm}
\alias{h_isemixnorm}
\title{The ISE-optimal bandwidth in the case when the true density is the specified mixture of normal distributions.}
\usage{
h_isemixnorm(x, w, mu, sdev)
}
\arguments{
\item{x}{numerical vector of data,}

\item{w}{vector of weighs (positive numbers between 0 and 1 that add up to one),}

\item{mu}{vector of means,}

\item{sdev}{vector of standard deviations.}
}
\value{
The ISE-optimal bandwidth.
}
\description{
Computing the ISE-optimal bandwidth in the case when the true density is the specified mixture of normal distributions and the Gaussian kernel is used to compute the ultimate density estimate.
}
\details{
Computing the ISE-optimal bandwidth (i.e. the minimizer of the ISE function) in the case when the true density is the mixture of normal distributions defined by the vector of weights \eqn{w}, the vector of means \eqn{\mu}, and the vector of standard deviations \eqn{\sigma}. See expression (2.3) of Marron and Wand (1992). It is assumed that the normals are defined as parsimonious as possible. The normal distributions in the mixture should be ordered such that the means in \eqn{\mu} are sorted in a nondecreasing order. The Gaussian kernel is used for computing the ultimate density estimate.
}
\examples{
# ISE optimal bandwidth for a random sample of size n=100 generated from a normal mixture defined by
# w=c(1/5,1/5,3/5), mu=(0,1/2,13/12), sdev=c(1,2/3,5/9).
# This corresponds to the skewed unimodal density of Marron and Wand (1992).
h_isemixnorm(rnorm(100),c(1/5,1/5,3/5),c(0,1/2,13/12),c(1,2/3,5/9))
}
\references{
Marron, J.S., Wand, M.P. (1992). Exact Mean Integrated Squared Error. \emph{The Annals of Statistics}, 20(2), 712-736.
}
\seealso{
\code{\link{mixnorm}}, \code{\link{ISE_mixnorm}}, \code{\link{MISE_mixnorm}}.
}

