% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd_showchanges.R
\name{icd_showchanges}
\alias{icd_showchanges}
\title{Show historical changes to selected ICD-10-GM codes}
\usage{
icd_showchanges(icd_in, years = NULL)
}
\arguments{
\item{icd_in}{Data frame created by  \code{\link[=icd_expand]{icd_expand()}}, containing codes to check}

\item{years}{Years to check, corresponding to the variable \code{year_from} in \code{icd_meta_transition}}
}
\value{
data.frame, as \code{icd_meta_transition}, with labels icd_from_label and icd_to_label
}
\description{
Show all changes in ICD history relating to the
3-digit codes contained in the data.frame icd_in.
The output of icd_expand can be passed directly to this
function to display relevant changes.
}
\examples{
dat_icd <- icd_expand(
   data.frame(ICD_SPEC = c("K52.9")),
   col_icd = "ICD_SPEC",
   year = 2019)
icd_showchanges(dat_icd)

}
\seealso{
\code{\link[=icd_showchanges_icd3]{icd_showchanges_icd3()}} to provide one or more three-digit codes as input
}
