% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{get_r_squared}
\alias{get_r_squared}
\title{R Squared Metrics for Predictions}
\usage{
get_r_squared(predictions, biomarker_values, model = "", threshold = 10)
}
\arguments{
\item{predictions}{(list)
A list with two elements, 'predictions' and 'panel_lengths',
as produced by the function get_predictions().}

\item{biomarker_values}{(dataframe)
A dataframe with two columns, 'Tumor_Sample_Barcode' and a
column with the name of the biomarker in question containing values.}

\item{model}{(character)
The name of the model type producing these predictions.}

\item{threshold}{(numeric)
Unusued in this function: present for calls to get_stats().}
}
\value{
A dataframe with 5 columns:
\itemize{
\item panel_length: the length of each panel.
\item model: the model that produced the predictions.
\item biomarker: the name of the biomarker in question.
\item stat: the R squared values for each panel.
\item metric: a constant character "R" for R squared.
}
}
\description{
A function to return R^2 metrics for predictions vs actual values. Works well when piped to straight from get_predictions().
}
\examples{
example_r <- get_r_squared(predictions = get_predictions(example_refit_panel, new_data =
  example_tables$val), biomarker_values = example_tmb_tables$val, model = "Refitted T")
}
