% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maf_to_tables.R
\name{get_biomarker_from_maf}
\alias{get_biomarker_from_maf}
\title{Produce a Table of Biomarker Values from a MAF}
\usage{
get_biomarker_from_maf(
  maf,
  biomarker = "TIB",
  sample_list = NULL,
  gene_list = NULL,
  biomarker_name = NULL
)
}
\arguments{
\item{maf}{(dataframe)
A table of annotated mutations containing the columns 'Tumor_Sample_Barcode', 'Hugo_Symbol', and 'Variant_Classification'.}

\item{biomarker}{(character)
Which biomarker needs calculating? If "TMB" or "TIB", then appropriate mutation types will be selected. Otherwise, will be interpreted as a vector of characters
denoting mutation types to include.}

\item{sample_list}{(character)
Vector of characters giving a list of values of Tumor_Sample_Barcode to include.}

\item{gene_list}{(character)
Vector of characters giving a list of genes to include in calculation of biomarker.}

\item{biomarker_name}{(character)
Name of biomarker. Only needed if biomarker is not "TMB" or "TIB"}
}
\value{
A dataframe with two columns, 'Tumor_Sample_Barcode' and values of the biomarker specified.
}
\description{
A function to recover true biomarker values from a mutation annotation file.
}
\examples{
print(head(get_biomarker_from_maf(example_maf_data$maf, sample_list = paste0("SAMPLE_", 1:100))))
}
