% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{all.abundance}
\alias{all.abundance}
\title{K-mer abundances}
\format{
See Description.
}
\usage{
all.abundance
}
\description{
An R list with one element each for 
\code{BSgenome.Hsapiens.1000genomes.hs37d5}, \cr
\code{BSgenome.Hsapiens.UCSC.hg38} and \code{BSgenome.Mmusculus.UCSC.mm10}.
Each element is in turn a sub-list keyed by 
\code{exome}, \code{transcript}, 
and \code{genome}. Each element of the sub list
is keyed by the number of rows in the catalog class (as a string, e.g. 
\code{"78"}, not \code{78}). The keys are:
78 (\code{DBS78Catalog}), 96 (\code{SBS96Catalog}), 136 (\code{DBS136Catalog}),
144 (\code{DBS144Catalog}), 192 (\code{SBS192Catalog}),
 and 1536 (\code{SBS1536Catalog}). So, for example to get the exome
 abundances for SBS96 catalogs for \code{BSgenome.Hsapiens.UCSC.hg38} exomes
 one would reference \cr
 \code{all.abundance[["BSgenome.Hsapiens.UCSC.hg38"]][["exome"]][["96"]]} \cr
 or \code{all.abundance$BSgenome.Hsapiens.UCSC.hg38$exome$"96"}.
 The value of the abundance is an integer vector with the K-mers
 as names and each value being the count of that K-mer.
}
\examples{
all.abundance$BSgenome.Hsapiens.UCSC.hg38$transcript$`144` 
#        AA        AC        AG        AT        CA        CC ... 
#  90769160  57156295  85738416  87552737  83479655  63267896 ...
# There are 90769160 AAs on the sense strands of transcripts in
# this genome.
}
\keyword{datasets}
