#' hkdeaths
#'
#' The original death by horse-kick data of von Bortkiewicz, with
#' extensions and a minor correction of an apparent transcription
#' error in the data quoted by von Bortkiewicz.  The time span is
#' extended from 1875-1894 to 1875-1907, and deaths by falling from a
#' horse and by drowning are also included.
#'
#' @format A data frame with 462 rows and 8 columns:
#' \describe{
#'     \item{year}{integer: The year of the record }
#'     \item{corps}{factor: The army corps involved }
#'     \item{regiments}{integer: The number of regiments in
#'                      the corps as given by von Bortkiewicz}
#'     \item{NCOs}{integer: The number of non-commissioned
#'                 officer horse-kick deaths.  These were
#'                 included in the total numbers and only
#'                 additionally separately reported up till
#'                 1899.}
#'     \item{kick}{integer: The number of deaths by horse-kick }
#'     \item{drown}{integer: The number of deaths by drowning }
#'     \item{fall}{integer: The number of deaths by falling from a horse }
#'     \item{vonB_kick}{integer: The original (shorter) horse-kick
#'                      deaths series used by von Bortkiewicz,
#'                      including the transcription error }
#' }
"hkdeaths"
