% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HighestMedianRules.R
\name{score}
\alias{score}
\title{Score}
\usage{
score(
  rule = "mj",
  grades = elec2012["Hollande", ],
  k = 0.5,
  scale = c(),
  name = "",
  print = TRUE,
  return_text = FALSE
)
}
\arguments{
\item{rule}{The voting rule to be used. Default to 'mj'. Possible values: 'mj' (majority judgment), 'd' (difference), 's' (relative share), 'n' (normalized difference), 'mean' (range voting). For more details, see "Tie-Breaking the Highest Median", Fabre, Social Choice & Welfare  (forthcoming).}

\item{grades}{A numeric vector containing the shares of each grades of a candidate, from the lowest grade to the highest.}

\item{k}{The quantile used to compute the gauge. Default to 0.5 (the median). For more details, see paragraph Extensions in 3.2.1 of "Tie-Breaking the Highest Median", Fabre, Social Choice & Welfare (forthcoming).}

\item{scale}{A numeric vector containing the values of the scale of grades. Default to c((floor(-length(grades)/2)+1):(length(grades)+floor(-length(grades)/2))).}

\item{name}{Text to be printed along the gauge in case print = TRUE and return_text = FALSE. Defaults to "".}

\item{print}{Prints the gauge and the argument 'name'. Default to TRUE.}

\item{return_text}{Prints the gauge. Defaults to FALSE. The gauge is less informative than the score, it is the median grade and \code{+} if there are grades higher than the median than lower, \code{-} otherwise.}
}
\value{
A double or a character. The score (a double) if \code{return_text = FALSE}, the gauge (a character) otherwise.
}
\description{
This function returns the score of a candidate, using a custom voting rule.
}
\examples{
score(rule='d', elec2012['Hollande',], scale=-2:4, name="Hollande")
}
