% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Probability_Best_Model_WAIC.R
\name{Probability_Best_Model_WAIC}
\alias{Probability_Best_Model_WAIC}
\title{Return the probability of models compared with loo being the best}
\usage{
Probability_Best_Model_WAIC(
  loos = stop("Results from loo::loo_compare() must be provided"),
  column.mean = "elpd_diff",
  column.se = "se_diff",
  order = TRUE,
  nreplicates = 10000,
  print = TRUE
)
}
\arguments{
\item{loos}{A named vector object}

\item{column.mean}{Name of the column of loos with means to compare.}

\item{column.se}{Name of the column of loos with se to compare.}

\item{order}{If TRUE, higher is better, if FALSE lower is better.}

\item{nreplicates}{Number of replicates.}

\item{print}{If TRUE, print the results}
}
\value{
A data.frame with the result of loo:compare()
}
\description{
Calculate the probability of models compared with loo being the best.
}
\details{
Probability_Best_Model_WAIC calculates the probability of models compared with loo being the best
}
\examples{
\dontrun{
Probability_Best_Model_WAIC(llok)
Probability_Best_Model_WAIC(llok, column.mean="elpd_loo", column.se="se_elpd_loo")
Probability_Best_Model_WAIC(llok, column.mean="p_loo", column.se="se_p_loo")
Probability_Best_Model_WAIC(llok, column.mean="looic", column.se="se_looic", order=FALSE)
}
}
\seealso{
Other AIC: 
\code{\link{ExtractAIC.glm}()},
\code{\link{FormatCompareAIC}()},
\code{\link{compare_AIC}()},
\code{\link{compare_AICc}()},
\code{\link{compare_BIC}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{AIC}
