% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circulant_mat.R
\name{circulant_mat}
\alias{circulant_mat}
\title{circulant_mat}
\usage{
circulant_mat(x = NA)
}
\arguments{
\item{x}{a vector to be used as intial row.}
}
\value{
circulant matrix of order length of input vector.
}
\description{
A matrix is said to be circulant if (i+1, j+1)th entry is equal to the
(i, j)th entry. Thus, for such matrices, the initial row determines the complex matrix. Whenever i+1,j+1 exceeds the order,
modulus operation is carried out.
}
\details{
circulant_mat performs construction of circulant matrices.
}
\examples{
circulant_mat(c(1,1,-1,0))
#      [,1] [,2] [,3] [,4]
#[1,]    1    1   -1    0
#[2,]    0    1    1   -1
#[3,]   -1    0    1    1
#[4,]    1   -1    0    1
circulant_mat(c(5,9,-7,-2))
#      [,1] [,2] [,3] [,4]
#[1,]    5    9   -7   -2
#[2,]   -2    5    9   -7
#[3,]   -7   -2    5    9
#[4,]    9   -7   -2    5
}
\references{
Hedayat, A. and Wallis, W.D. (1978). Hadamard Matrices and Their Application.Ann. Stat., 6, 1184-1238.
}
