% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_volcano.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Volcano plot}
\usage{
plot_volcano(
  p_dat,
  state_1 = "",
  state_2 = "",
  adjust_axes = TRUE,
  show_confidence_limits = FALSE,
  confidence_level = 0.98,
  color_times = TRUE,
  show_insignificant_grey = FALSE,
  hide_insignificant = FALSE,
  fractional = FALSE,
  theoretical = FALSE,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{p_dat}{data produced by the \code{\link{create_p_diff_uptake_dataset}}
function}

\item{state_1}{selected biological state for given protein}

\item{state_2}{selected biological state for given protein}

\item{adjust_axes}{\code{\link{logical}}, indicator if the X-axis 
is symmetrical in relation to 0}

\item{show_confidence_limits}{\code{\link{logical}}, indicates if the hybrid 
test confidence levels are shown}

\item{confidence_level}{confidence level for the test, from range [0, 1]. It
should be the same as used to prepare p_dat}

\item{color_times}{\code{\link{logical}}, indicator if different time points 
are distinguishable by color}

\item{show_insignificant_grey}{\code{\link{logical}}, indicator if the 
values not passing the test are shown in grey}

\item{hide_insignificant}{\code{\link{logical}}, indicator if the 
values not passing the test are hidden}

\item{fractional}{\code{logical}, indicator if values are shown 
in fractional form}

\item{theoretical}{\code{logical}, indicator if values are 
calculated using theoretical controls}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Volcano plot for differential deuterium uptake
between two biological states
}
\details{
The function \code{\link{plot_volcano}} generates the 
volcano plot based on supplied p_dat. 
On X-axis there is differential deuterium uptake in selected form.
On Y-axis there is the P-value from t-Student test between two
biological states. Based on selected confidence level, the confidence
limits are calculated to indicate statistically significant values -
shown as red dotted lines. The values that are in upper left and right
corners pass the hybrid test.
}
\examples{
p_dat <- create_p_diff_uptake_dataset(alpha_dat)
plot_volcano(p_dat, show_confidence_limits = TRUE)

plot_volcano(p_dat, show_confidence_limits = TRUE, show_insignificant_grey = TRUE)
plot_volcano(p_dat, show_confidence_limits = TRUE, hide_insignificant = TRUE)

}
\references{
Hageman, T. S. & Weis, D. D. Reliable Identification of Significant
Differences in Differential Hydrogen Exchange-Mass Spectrometry Measurements
Using a Hybrid Significance Testing Approach. Anal Chem 91, 8008–8016 (2019).

Houde, D., Berkowitz, S.A., and Engen, J.R. (2011).
The Utility of Hydrogen/Deuterium Exchange Mass Spectrometry in
Biopharmaceutical Comparability Studies. J Pharm Sci 100, 2071–2086.
}
\seealso{
\code{\link{create_p_diff_uptake_dataset}}
}
