% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_diff_uptake_dataset.R
\name{create_diff_uptake_dataset}
\alias{create_diff_uptake_dataset}
\title{Generate differential dataset}
\usage{
create_diff_uptake_dataset(
  dat,
  protein = unique(dat[["Protein"]])[1],
  state_1 = unique(dat[["State"]])[1],
  state_2 = unique(dat[["State"]])[2],
  time_0 = min(dat[["Exposure"]]),
  time_100 = max(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{state_1}{biological state for chosen protein. From this state values
the second state values are subtracted to get the deuterium uptake difference.}

\item{state_2}{biological state for chosen protein. This state values are 
subtracted from the first state values to get the deuterium uptake difference.}

\item{time_0}{minimal exchange control time point of measurement [min].}

\item{time_100}{maximal exchange control time point of measurement [min].}

\item{deut_part}{deuterium percentage in solution used in experiment, 
value from range [0, 1].}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Calculates differential deuterium uptake values 
between two states.
}
\details{
The function \code{\link{create_diff_uptake_dataset}} 
generates a dataset with differential values between given biological states 
(state_1 - state_2). For each peptide of chosen protein for time points of 
measurement between minimal and maximal control time points of measurement 
deuterium uptake difference, fractional deuterium uptake difference with 
respect to controls or theoretical tabular values are calculated, with 
combined and propagated uncertainty. Each peptide has an ID, based on its start
position.
Function output can be visualized as a differential (Woods) plot, butterfly
differential plot or chiclet differential plot.
}
\examples{
diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
head(diff_uptake_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_diff_uptake}}
\code{\link{plot_differential_butterfly}}
\code{\link{plot_differential_chiclet}}
\code{\link{plot_differential}}
}
