% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_aggregated_difference.R
\name{calculate_aggregated_diff_uptake}
\alias{calculate_aggregated_diff_uptake}
\title{Calculates aggregated deuterium uptake difference for one time point}
\usage{
calculate_aggregated_diff_uptake(diff_uptake_dat, time_t)
}
\arguments{
\item{diff_uptake_dat}{differential uptake data, 
product of e.q. \code{\link{create_diff_uptake_dataset}}}

\item{time_t}{chosen time point}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Function aggregates the differential deuterium uptake values from
peptide level into single-amino resolution using `weighted
approach` (defined in `vignette("datafiles"))`. For 
visualization use \code{\link{plot_aggregated_uptake}}
}
\examples{
diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
calculate_aggregated_diff_uptake(diff_uptake_dat, time_t = 5)

}
