% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_vanrijn1984.R
\name{n_vanrijn1984}
\alias{n_vanrijn1984}
\title{Compute channel form roughness following Van Rijn (1984)}
\usage{
n_vanrijn1984(depth, slope, d50, d90, velocity, restrict = TRUE)
}
\arguments{
\item{depth}{flow depth (H) in meters. The original model was calibrated for 0.1 < H < 16 m.}

\item{slope}{channel slope (S) in m/m}

\item{d50}{grain size (d50) in millimeters. The original model was calibrated
for 0.19 mm < d50 < 3.6 mm.}

\item{d90}{grain size (d90) in millimeters.}

\item{velocity}{initial channel velocity estimate (U) in meters per second}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_vanrijn1984} calculate Manning's n using the Van Rijn (1984) method for
estimating roughness due to channel form
}
\examples{
# Result: Manning's n of 0.173
n_vanrijn1984(10,0.025,1,2,6)

# Result: Manning's n of 0.047
n_vanrijn1984(0.33,0.15,0.3,0.5,2)

# Result: Manning's n of 0.028
n_vanrijn1984(1.55,0.033,0.5,0.8,1)

# Result: Depth must be within 0.025 and 17 m.
n_vanrijn1984(0.01,0.033,0.5,0.8,1)

}
\references{
van Rijn, L. C. 1984a. Sediment Transport, Part I: Bed Load Transport. Journal of Hydraulic Engineering. ASCE,
Vol. 110 (10), pp. 1431-1456.

van Rijn, L. C. 1984b. Sediment Transport, Part II: Suspended Load Transport. Journal of Hydraulic Engineering.
ASCE, Vol. 110 (11), pp. 1613-1641.

van Rijn, L. C. 1984c. Sediment Transport, Part III: Bed Forms and Alluvial Roughness. Journal of Hydraulic
Engineering. ASCE, Vol. 110 (12), pp. 1733-1754.
}
