% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HNPclassifier.r
\name{hnp_summary}
\alias{hnp_summary}
\title{hnp_summary
Summarize a ternary classifier's performance}
\usage{
hnp_summary(classifier, data, class_col, class_number = NULL)
}
\arguments{
\item{classifier}{A function \code{function(X) { ... }} that returns class labels
1/2/3 for a single-row data.frame or vectorized over rows.}

\item{data}{A data.frame containing features and the true class column.}

\item{class_col}{Character scalar. Name of the true class/label column.}

\item{class_number}{Optional integer. Number of classes; if \code{NULL}, inferred
from the data.}
}
\value{
A list with components: \code{confusion_matrix}, \code{false_positive_rate},
\code{false_negative_rate}, \code{overall_accuracy}, \code{predictions},
\code{under_classification_error}, \code{over_classification_error},
\code{total_over_classification_error}, \code{total_under_classification_error}, and
\code{error_table}.
}
\description{
Compute confusion matrix, class-wise false positive/negative
rates, over- and under-classification errors, overall accuracy, and a
normalized error table for a ternary classifier produced by the HNP
pipeline.
}
\examples{
set.seed(123)
n <- 50
x <- data.frame(a = rnorm(n), b = rnorm(n))
y <- factor(sample(c("1","2","3"), n, TRUE))
df <- cbind(x, y)
clf <- function(X) sample(c(1,2,3), nrow(X), replace=TRUE)
res <- hnp_summary(clf, data = df, class_col = "y")
}
