% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GofHMMCop.R
\name{GofHMMCop}
\alias{GofHMMCop}
\title{Goodness-of-fit of Markov regime switching bivariate copula model}
\usage{
GofHMMCop(R, reg, family, max_iter, eps, n_sample, n_cores)
}
\arguments{
\item{R}{(n x 2) data matrix that will be transformed to pseudo-observations}

\item{reg}{number of regimes}

\item{family}{'gaussian' , 't' , 'clayton' , 'frank' , 'gumbel'}

\item{max_iter}{maxmimum number of iterations of the EM algorithm}

\item{eps}{precision (stopping criteria); suggestion 0.0001}

\item{n_sample}{number of bootstrap; suggestion 1000}

\item{n_cores}{number of cores to use in the parallel computing}
}
\value{
\item{pvalue}{pvalue (significant when the result is greater than 5)}

\item{theta}{(1 x reg) estimated parameter of the copula according to CRAN copula package (except for Frank copula, where theta = log(theta_R_Package)) for each regime (except for degrees of freedom)}

\item{dof}{estimated degree of freedom, only for the Student copula}

\item{Q}{(reg x reg) estimated transition matrix}

\item{eta}{(n x reg) conditional probabilities of being in regime k at time t given observations up to time t}

\item{tau}{estimated Kendall tau for each regime}

\item{U}{(n x 2) matrix of Rosenblatt transforms}

\item{cvm}{Cramer-von-Mises statistic for goodness-of-fit}

\item{W}{regime probabilities for the conditional distribution given the past Kendall's tau}
}
\description{
Goodness-of-fit test of a Markov regime switching bivariate copula model
}
\references{
<doi::10.1002/cjs.11534>
}
