% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pymol_script_average_residue.R
\name{pymol_script_average_residue}
\alias{pymol_script_average_residue}
\title{Writes a text files with pymol scripts to list significant residues.}
\usage{
pymol_script_average_residue(
  df,
  path = "",
  ranges = c(-Inf, seq(-30, 30, by = 10), Inf),
  pv_cutoff = 0.01,
  replicates = 3
)
}
\arguments{
\item{df}{output from functions output_tp}

\item{path}{output folder location}

\item{ranges}{ranges for coloring scheme. Default set to c(-Inf, seq(-30, 30, by=10), Inf)}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{replicates}{number of replicates in sample. Default set to 3.}
}
\value{
pymol script with residues colored based on average of uptake per residue.
}
\description{
Function write a script that can be used in pymol to color structure.
Number of colors and corresponding to them ranges can be defined by user.
Residues are being colored by average uptake values from the significant peptides per residues.
}
\examples{
\donttest{
file_nm<-system.file("extdata", "All_results_table.csv", package = "HDXBoxeR")
a<- output_tp(file_nm)
pymol_script_average_residue(df=a, replicates=3, pv_cutoff=0.01,
ranges=c(-Inf,-40, -30,-20,-10, 0,10, 20,30,40, Inf), path=tempdir() )
pymol_script_average_residue(df=a,  path=tempdir())
}
}
