% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvSingleModalityAdmm.R
\name{cvSingleModalityAdmm}
\alias{cvSingleModalityAdmm}
\title{Cross Validation for High-dimensional Single Mediation Models}
\usage{
cvSingleModalityAdmm(
  X,
  Y,
  M1,
  numFolds = 10,
  typeMeasure = "rmse",
  lambda1a,
  lambda1b,
  lambda1g,
  lambda2a,
  lambda2b,
  rho = 1,
  penalty = "ElasticNet",
  penaltyParameterList = list(),
  SIS = FALSE,
  SISThreshold = 2,
  maxIter = 3000,
  tol = 1e-04,
  verbose = FALSE,
  debug = FALSE
)
}
\arguments{
\item{X}{The matrix of independent variables (exposure/treatment/group).}

\item{Y}{The vector of dependent variable (outcome response).}

\item{M1}{The single-modality mediator.}

\item{numFolds}{The number of folds. The default is 10. Although nfolds can be as large as the sample size (leave-one-out CV),
it is not recommended for large datasets. Smallest value allowable is nfolds=3.}

\item{typeMeasure}{Default is "rmse".}

\item{rho, lambda1g, lambda1a, lambda1b, lambda2a, lambda2b, penaltyParameterList}{Allow to put sequences for each parameter. Please refer to the function, \code{\link{singleModalityAdmm}} for the details.}

\item{penalty, SIS, SISThreshold, maxIter, tol, verbose, debug}{Please refer to the function, \code{\link{singleModalityAdmm}}.}
}
\value{
An \code{cvSingleModalityAdmm} object which is a matrix containing all the combinations of parameter sequences with an additional column called \code{measure}.
}
\description{
Cross Validation for High-dimensional Single Mediation Models
}
\examples{
\donttest{
## Generate Empirical Data
simuData <- modalityMediationDataGen(seed = 20231201)

## Cross-Validation for ElasticNet penalty
cvElasticNetResults <- cvSingleModalityAdmm(
  X = simuData$MediData$X, Y = simuData$MediData$Y, M1 = simuData$MediData$M1,
  numFolds = 5, typeMeasure = "rmse",
  rho = c(0.9, 1, 1.1), lambda1a = c(0.1, 0.5, 1), lambda1b = c(0.1, 0.3),
  lambda1g = c(1, 2), lambda2a = c(0.5, 1), lambda2b = c(0.5, 1),
  penalty = "ElasticNet"
)

## Cross-Validation for Pathway Lasso penalty (lambda2a, lambda2b are not tuned.)
cvPathwayLassoResults <- cvSingleModalityAdmm(
  X = simuData$MediData$X, Y = simuData$MediData$Y, M1 = simuData$MediData$M1,
  numFolds = 5, typeMeasure = "rmse",
  rho = c(0.9, 1, 1.1), lambda1a = c(0.1, 0.5, 1), lambda1b = c(0.1, 0.3),
  lambda1g = c(1, 2), lambda2a = 1, lambda2b = 1,
  penalty = "PathwayLasso", penaltyParameterList = list(kappa = c(0.5, 1), nu = c(1, 2))
)
}
}
