% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_subgaussian.R
\name{verify_subgaussian}
\alias{verify_subgaussian}
\title{Verify sub-Gaussian preservation}
\usage{
verify_subgaussian(g_fun, m = 5, n = 1000, cut = exp(2))
}
\arguments{
\item{g_fun}{vectorised map g: R -> R}

\item{m}{latent dimension}

\item{n}{Monte-Carlo sample size}

\item{cut}{empirical threshold (default exp(2) & 7.389)}
}
\value{
logical TRUE if E[exp(g)] < cut on all coords
}
\description{
Draws n i.i.d. N(0, I_m) latent factors, applies g component-wise,
and checks whether E[exp(g(x))] remains below an empirical cut-off.
This is a quick proxy for finite sub-Gaussian norm.
}
\examples{
  tmp <- g_fun("strong_nonlinear")
  verify_subgaussian(tmp$g_fun, m = 5)
}
