% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blp.R
\name{BLP}
\alias{BLP}
\title{Performs BLP regression}
\usage{
BLP(
  Y,
  D,
  propensity_scores,
  proxy_BCA,
  proxy_CATE,
  HT = FALSE,
  X1_control = setup_X1(),
  vcov_control = setup_vcov(),
  significance_level = 0.05
)
}
\arguments{
\item{Y}{A numeric vector containing the response variable.}

\item{D}{A binary vector of treatment assignment. Value one denotes assignment to the treatment group and value zero assignment to the control group.}

\item{propensity_scores}{A numeric vector of propensity scores. We recommend to use the estimates of a \code{"\link{propensity_score}"} object.}

\item{proxy_BCA}{A numeric vector of proxy baseline conditional average (BCA) estimates. We recommend to use the estimates of a \code{"\link{proxy_BCA}"} object.}

\item{proxy_CATE}{A numeric vector of proxy conditional average treatment effect (CATE) estimates. We recommend to use the estimates of a \code{"\link{proxy_CATE}"} object.}

\item{HT}{Logical. If \code{TRUE}, a Horvitz-Thompson (HT) transformation is applied (BLP2 in the paper). Default is \code{FALSE}.}

\item{X1_control}{Specifies the design matrix \eqn{X_1} in the regression. Must be an object of class \code{"\link{setup_X1}"}. See the documentation of \code{\link{setup_X1}()} for details.}

\item{vcov_control}{Specifies the covariance matrix estimator. Must be an object of class \code{"\link{setup_vcov}"}. See the documentation of \code{\link{setup_vcov}()} for details.}

\item{significance_level}{Significance level. Default is 0.05.}
}
\value{
An object of class \code{"BLP"}, consisting of the following components:
\describe{
\item{\code{generic_targets}}{A matrix of the inferential results on the BLP generic targets.}
\item{\code{coefficients}}{An object of class \code{"\link[lmtest]{coeftest}"}, contains the coefficients of the BLP regression.}
\item{\code{lm}}{An object of class \code{"\link[stats]{lm}"} used to fit the linear regression model.}
}
}
\description{
Performs the linear regression for the Best Linear Predictor (BLP) procedure.
}
\examples{
## generate data
set.seed(1)
n  <- 150                        # number of observations
p  <- 5                          # number of covariates
D  <- rbinom(n, 1, 0.5)          # random treatment assignment
Y  <- runif(n)                   # outcome variable
propensity_scores <- rep(0.5, n) # propensity scores
proxy_BCA         <- runif(n)    # proxy BCA estimates
proxy_CATE        <- runif(n)    # proxy CATE estimates

## perform BLP
BLP(Y, D, propensity_scores, proxy_BCA, proxy_CATE)

}
\references{
Chernozhukov V., Demirer M., Duflo E., Fernández-Val I. (2020). \dQuote{Generic Machine Learning Inference on Heterogenous Treatment Effects in Randomized Experiments.} \emph{arXiv preprint arXiv:1712.04802}. URL: \url{https://arxiv.org/abs/1712.04802}.
}
\seealso{
\code{\link{setup_X1}()},
\code{\link{setup_diff}()},
\code{\link{setup_vcov}()},
\code{\link{propensity_score}()},
\code{\link{proxy_BCA}()},
\code{\link{proxy_CATE}()}
}
