% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_matrix.R
\name{adj_matrix}
\alias{adj_matrix}
\title{Binary adjacency matrix}
\usage{
adj_matrix(i, j = NULL)
}
\arguments{
\item{i}{a vector or, if j = NULL a data.frame with two 
columns indicating from-to relationships (joins)}

\item{j}{If specified, i must be a vector of same length and
the i,j vectors must represent joins}
}
\value{
A binary matrix
}
\description{
Creates a binary matrix of adjacencies based on 
             from-to graph relationships (joins)
}
\examples{
 library(sf)
   data(ralu.site, package="GeNetIt")
   
 p <- as(ralu.site, "sf")
 g <- knn.graph(p[c(1,5,8,10,20,31),])
   plot(st_geometry(g))

 ( ind <- sf::st_drop_geometry(g[,1:2])[1:10,] ) 

 adj_matrix(ind)

 adj_matrix(g$i[1:10], g$j[1:10])

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and 
        Melanie A. Murphy <melanie.murphy@uwyo.edu>
}
