% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2026-01-21_s4_class_methods.R
\name{galaxy_poll_workflow}
\alias{galaxy_poll_workflow}
\alias{galaxy_poll_workflow,character-method}
\alias{galaxy_poll_workflow,Galaxy-method}
\title{Generic for polling workflows}
\usage{
galaxy_poll_workflow(
  x,
  galaxy_url = "https://usegalaxy.eu",
  poll_interval = 30,
  ...
)

\S4method{galaxy_poll_workflow}{character}(
  x,
  galaxy_url = "https://usegalaxy.eu",
  poll_interval = 30,
  ...
)

\S4method{galaxy_poll_workflow}{Galaxy}(
  x,
  galaxy_url = "https://usegalaxy.eu",
  poll_interval = 30,
  ...
)
}
\arguments{
\item{x}{A workflow invocation ID (\code{character}) or a \code{Galaxy} object.}

\item{galaxy_url}{Base URL of the Galaxy instance, used by the character
method. If \code{GALAXY_URL} is set it takes precedence.}

\item{poll_interval}{Time in seconds between polling attempts.}

\item{...}{not in use}
}
\value{
For the character method, a list with elements \code{success} and
\code{output_ids}. For the \code{Galaxy} method, the modified \code{Galaxy} object.
}
\description{
\code{galaxy_poll_workflow()} is an S4 generic. With \code{x} as a character vector it
is treated as a workflow invocation ID; the invocation is polled until it
completes and a list of output dataset IDs is returned. With \code{x} as a
\code{Galaxy} object, the \code{invocation_id} and \code{galaxy_url} are taken from the
object, and the object is updated with the resulting \code{output_dataset_ids} and
state.
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
invocation_id <- "abc123"
galaxy_poll_workflow(invocation_id)
\dontshow{\}) # examplesIf}
}
