% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_get_workflow_inputs}
\alias{galaxy_get_workflow_inputs}
\title{Retrieve input definitions for a Galaxy workflow}
\usage{
galaxy_get_workflow_inputs(workflow_id, galaxy_url = "https://usegalaxy.eu")
}
\arguments{
\item{workflow_id}{Character. Galaxy workflow ID.}

\item{galaxy_url}{Character. Base URL of the Galaxy instance
(for example \code{"https://usegalaxy.eu"}).
If the environment variable \code{GALAXY_URL} is set, it takes precedence.}
}
\value{
A data.frame with one row per workflow input and the columns:
\code{step_id}, \code{name}, \code{type}, \code{optional}, \code{default}.
}
\description{
Retrieves and summarizes the input steps required by a Galaxy workflow.
}
\details{
This function queries \code{/api/workflows/{workflow_id}} and extracts
workflow input steps (data and parameter inputs). The returned
\code{step_id} values must be used as names in the \code{inputs} argument
of \code{galaxy_start_workflow}.
}
\examples{
\dontshow{if (nzchar(Sys.getenv("GALAXY_API_KEY"))) withAutoprint(\{ # examplesIf}
\dontrun{
galaxy_get_workflow_inputs("f2db41e1fa331b3e")
}
\dontshow{\}) # examplesIf}
}
