% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2026-01-21_s4_class_methods.R
\name{galaxy_download_rocrate}
\alias{galaxy_download_rocrate}
\alias{galaxy_download_rocrate,character-method}
\alias{galaxy_download_rocrate,Galaxy-method}
\title{Generic for downloading a history as an RO-Crate}
\usage{
galaxy_download_rocrate(
  x,
  dest_file = tempfile(fileext = ".zip"),
  galaxy_url = "https://usegalaxy.eu",
  format = "rocrate.zip",
  poll_interval = 5,
  timeout = 600
)

\S4method{galaxy_download_rocrate}{character}(
  x,
  dest_file = tempfile(fileext = ".zip"),
  galaxy_url = "https://usegalaxy.eu",
  format = "rocrate.zip",
  poll_interval = 30,
  timeout = 600
)

\S4method{galaxy_download_rocrate}{Galaxy}(
  x,
  dest_file = tempfile(fileext = ".zip"),
  format = format,
  poll_interval = 5,
  timeout = 600
)
}
\arguments{
\item{x}{A history ID (\code{character}), or a \code{Galaxy} object.}

\item{dest_file}{Path to save the downloaded RO-Crate (defaults to a
temporary \code{.zip} file).}

\item{galaxy_url}{Base URL of the Galaxy instance, used by the character
method. If \code{GALAXY_URL} is set it takes precedence.}

\item{format}{Format for the history export. Possible formats depend on the Galaxy
server. Typical inputs are 'tgz', 'tar', 'tar.gz', 'bag.zip', 'bag.tar', 'bag.tgz',
'rocrate.zip' or 'bco.json'. Defaults to 'rocrate.zip'.}

\item{poll_interval}{Seconds between status checks.}

\item{timeout}{Maximum time to wait in seconds before giving up.}
}
\value{
For the character method, the path to the downloaded file. For the
\code{Galaxy} method, the (unchanged) \code{Galaxy} object invisibly.
}
\description{
\code{galaxy_download_rocrate()} is an S4 generic. With \code{x} as a history ID
(\code{character}) it requests an export in RO-Crate format, polls until ready,
and downloads the archive to \code{dest_file}. With \code{x} as a \code{Galaxy} object,
its \code{history_id} and \code{galaxy_url} are used and the object is returned
invisibly after performing the download.
}
\examples{
\dontshow{if (galaxy_has_key()) withAutoprint(\{ # examplesIf}
hid <- "0123456789abcdef"
crate <- galaxy_download_rocrate(hid, dest_file = "history_rocrate.zip")
g <- galaxy()
g <- galaxy_initialize(g)
g <- galaxy_download_rocrate(g, dest_file = "history_rocrate.zip")
\dontshow{\}) # examplesIf}
}
