% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GVS_metadata.R
\name{GVS_metadata}
\alias{GVS_metadata}
\title{Get GVS metadata}
\usage{
GVS_metadata(bibtex_file = NULL, ...)
}
\arguments{
\item{bibtex_file}{Optional output file for writing bibtex citations.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
List containing: (1) bibtex-formatted citation information, (2) information about GVS data sources, and (3) GVS version information.
}
\description{
Returns metadata on GVS including version and citation information
}
\note{
This function provides citation information in bibtex format that can be used with reference manager software (e.g., Paperpile, Zotero). Please remember to cite both the sources and the GVS, as the GVS couldn't exist without these sources!

This function is a wrapper that returns the output of the functions GVS_citations, GVS_sources, and GVS_version.
}
\examples{
{
metadata <- GVS_metadata()
}

}
