\name{getWhiteCOEFexo}
\alias{getWhiteCOEFexo}

\title{Extract all-country coefficient estimates with White robust covariance.
}

\encoding{latin1}


\description{Extract all-country coefficient estimates with Newy-West robust covariance, and save them in a .csv file.
}
\usage{getWhiteCOEFexo(out)
}

\arguments{
  \item{out}{A list object of estimation results generated by GVARest.
}

}

\value{
  \item{coef}{Country-specific coefficient estimates.}

}

\author{Ho Tsung-wu <tsungwu@ntnu.edu.tw>, College of Management, National Taiwan Normal University.
}

\examples{
data("PriceVol")
data("tradeweight1")
data("tradeweightx")
p=2
FLag=2
lag.max=15
type="const"
ic="SC"
weight.matrix=tradeweightx
mainOUTPUT = GVARest(data=PriceVol,p,lag.max,type,ic,weight.matrix)
COEF=getWhiteCOEFexo(out=mainOUTPUT)
}
