% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSGA.R
\name{generate_disease_component}
\alias{generate_disease_component}
\title{Generate disease component matrix.}
\usage{
generate_disease_component(full_data, normal_space)
}
\arguments{
\item{full_data}{Input matrix whose columns correspond to the patients and
rows to the gens. Both tumour and healthy samples should be included.}

\item{normal_space}{Denoised flattened matrix constructed from
"healthy tissue data". Output of the function \code{denoise_rectangular_matrix}.}
}
\value{
Disease component matrix that contains the disease component
of the provided normal space
}
\description{
This function produces a disease component matrix
from an expression matrix and the denoised flattened matrix constructed
from "healthy tissue data".
}
\examples{
\donttest{
full_data <- matrix(stats::rnorm(120),ncol=20)
normal_tissue <- t(full_data)
normal_tissue_f <- flatten_normal_tiss(normal_tissue)
normal_tissue_f_d <- denoise_rectangular_matrix(normal_tissue_f, gamma=NA)
disease_component <- generate_disease_component(t(full_data),normal_tissue_f_d)}
}
