% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRSxE.R
\name{GxE}
\alias{GxE}
\title{Testing individual gene-environment interactions}
\usage{
GxE(G, y, E, C = NULL)
}
\arguments{
\item{G}{Numeric vector of a genetic variable such as a GRS (genetic risk
score) or a SNP coded as 0-1-2.}

\item{y}{Numeric vector of the outcome/phenotype. Binary outcomes such
as a disease status should be coded as 0-1 (control-case).}

\item{E}{Numeric vector of the environmental exposure.}

\item{C}{Optional data frame containing potentially confounding
variables to be adjusted for.}
}
\value{
An object of class \code{glm} is returned, in which \code{G:E}
  describes the GxE term.
}
\description{
Function for testing univariate GxE interactions, e.g., using single SNPs
or a GRS.
}
\details{
This function uses a GLM (generalized linear model) for modelling the
marginal genetic effect, marginal environmental effect, the GxE interaction
effect, and potential confounding effects.
The fitted GLM is returned, which can be, e.g., inspected via
\code{summary(...)} to retrieve the Wald test p-values for the individual
terms. The p-value corresponding to the \code{G:E} term is the p-value
for testing the presence of a GxE interaction.
}
\references{
\itemize{
  \item Lau, M., Kress, S., Schikowski, T. & Schwender, H. (2023).
  Efficient gene--environment interaction testing through
  bootstrap aggregating. Scientific Reports 13:937.
  \doi{https://doi.org/10.1038/s41598-023-28172-4}
}
}
