% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order.index.lsn.data.R
\name{order.index.lsn.data}
\alias{order.index.lsn.data}
\title{Order and Index Lesion Data}
\usage{
order.index.lsn.data(lsn.data)
}
\arguments{
\item{lsn.data}{A \code{data.frame} containing lesion data formatted for GRIN. It must include the following five columns:
\describe{
\item{"ID"}{Patient identifier.}
\item{"chrom"}{Chromosome on which the lesion is located.}
\item{"loc.start"}{Start position of the lesion.}
\item{"loc.end"}{End position of the lesion.}
\item{"lsn.type"}{Lesion type (e.g., gain, loss, mutation, fusion, etc...).}
}}
}
\value{
A list with two elements:
\item{lsn.data}{The input lesion data, ordered by lesion type, chromosome, and subject.}
\item{lsn.index}{A \code{data.frame} with two columns, \code{row.start} and \code{row.end}, indicating the index range of lesions for each subject-lesion type-chromosome combination. For example, if a patient has a single deletion on chromosome 5, \code{row.start} will equal \code{row.end}. If there are four deletions, the range will span four rows.}
}
\description{
This function orders and indexes lesion data by lesion type, chromosome, and subject ID. It prepares lesion data for downstream GRIN analysis by structuring it in a way that facilitates efficient access and overlap computations.
}
\examples{
data(lesion_data)

ordered.lsn <- order.index.lsn.data(lesion_data)
}
\references{
Pounds, S., et al. (2013). A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
