% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/order.index.gene.data.R
\name{order.index.gene.data}
\alias{order.index.gene.data}
\title{Order and Index Gene Annotation Data}
\usage{
order.index.gene.data(gene.data)
}
\arguments{
\item{gene.data}{A \code{data.frame} containing gene annotation information, either provided by the user or retrieved using the \code{get.ensembl.annotation} function from the GRIN2.0 package. The \code{data.frame} must contain four columns:
\describe{
\item{"gene"}{Ensembl gene ID.}
\item{"chrom"}{Chromosome on which the gene is located.}
\item{"loc.start"}{Start position of the gene.}
\item{"loc.end"}{End position of the gene.}
}}
}
\value{
A list with two components:
\item{gene.data}{The input gene annotation data, ordered by chromosome and genomic coordinates.}
\item{gene.index}{A \code{data.frame} with two columns (\code{row.start} and \code{row.end}) indicating the row indices for genes on each chromosome.}
}
\description{
This function orders and indexes gene annotation data by chromosome, gene start, and gene end positions. It is typically used to prepare gene data for overlap analyses with lesion data.
}
\examples{
data(hg38_gene_annotation)

ordered.genes <- order.index.gene.data(hg38_gene_annotation)
}
\references{
Pounds, S., et al. (2013). A genomic random interval model for statistical analysis of genomic lesion data.

Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\author{
Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}
}
