% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia_wrappers.R
\name{vecchia_pred}
\alias{vecchia_pred}
\title{make spatial predictions using Vecchia based on estimated parameters}
\usage{
vecchia_pred(vecchia.est, locs.pred, X.pred, m = 30, ...)
}
\arguments{
\item{vecchia.est}{object returned by \code{\link{vecchia_estimate}}}

\item{locs.pred}{n.p x d matrix of prediction locations}

\item{X.pred}{n.p x p matrix of trend covariates at prediction locations.
does not need to be specified if constant or no trend was used in
\code{\link{vecchia_estimate}}}

\item{m}{number of neighbors for vecchia approximation. default is 30.}

\item{...}{additional input parameters for \code{\link{vecchia_specify}}}
}
\value{
object containing prediction means mean.pred and variances var.pred
}
\description{
make spatial predictions using Vecchia based on estimated parameters
}
\examples{
\donttest{
n=10^2; locs=cbind(runif(n),runif(n))
covparms=c(1,.1,.5); nuggets=rep(.1,n)
Sigma=exp(-fields::rdist(locs)/covparms[2])+diag(nuggets)
z=as.numeric(t(chol(Sigma))\%*\%rnorm(n));
data=z+1
vecchia.est=vecchia_estimate(data,locs,theta.ini=c(covparms,nuggets[1]))
n.p=30^2; grid.oneside=seq(0,1,length=round(sqrt(n.p)))
locs.pred=as.matrix(expand.grid(grid.oneside,grid.oneside))
vecchia.pred=vecchia_pred(vecchia.est,locs.pred)
}
}
