% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{real_data}
\alias{real_data}
\title{Real Data Analysis with Model Fitting and Visualization}
\usage{
real_data(
  data_path,
  window_size,
  model,
  parameter,
  cov = FALSE,
  Plot_est = FALSE,
  p_value_plot = FALSE,
  tolerance = 0.05
)
}
\arguments{
\item{data_path}{A character string specifying the path to the data file. Supported file types are TXT and CSV.}

\item{window_size}{An integer specifying the size of the moving window for localized estimation. Default is 3.}

\item{model}{A character string specifying the model to fit. Options are "Logistic", "Von-Bertalanffy", and "Gompertz".}

\item{parameter}{A list containing initial parameter estimates. For "Logistic" and "Von-Bertalanffy" models, the list should include \code{r} and \code{K}. For the "Gompertz" model, it should include \code{c} and \code{b}.}

\item{cov}{A logical value indicating whether to return the covariance matrices. Default is FALSE.}

\item{Plot_est}{A logical value indicating whether to generate plots of the estimated parameters. Default is FALSE.}

\item{p_value_plot}{A logical value indicating whether to generate plots of p-values for local estimates. Default is FALSE.}

\item{tolerance}{A numeric value specifying the alpha level for p-value calculation. Default is 0.05.}
}
\value{
A list containing:
\item{est_global}{A vector of global parameter estimates.}
\item{cov_global}{A matrix of global covariance estimates (if \code{cov} is TRUE).}
\item{est_local}{A matrix of local parameter estimates.}
\item{cov_local}{A list of local covariance matrices (if \code{cov} is TRUE).}
\item{est_plot}{A plot of the estimated parameters (if \code{Plot_est} is TRUE).}
\item{p_value_plot}{A plot of p-values for local estimates (if \code{p_value_plot} is TRUE).}
}
\description{
This function performs parameter estimation for specified models (Logistic, Von-Bertalanffy, or Gompertz) using real data from a TXT or PDF file. It calculates global and local estimates of the model parameters, including their covariance matrices, and optionally generates plots of the estimates and p-values.
}
\examples{
data_csv <- system.file("extdata", "sample_data.csv", package = "GPEMR")
results_logistic <- real_data(data_csv, window_size = 5, model = "Logistic",
                              parameter = list(r= 0.7), cov = TRUE, Plot_est = TRUE)

}
