% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpcmStruct.R
\name{show}
\alias{show}
\alias{show.gpcm}
\title{Print values of a  Gaussian Process Classification (GPC) model}
\usage{
show.gpcm(object)
}
\arguments{
\item{object}{an object of class \code{gpcm}. See \code{\link{gpcm}}.}
}
\value{
returns an invisible 'NULL'
}
\description{
Show method for \code{gpcm} object. Printing the main features of a GPC model.
}
\examples{
## 20-points DoE, and the corresponding response
d <- 2
nb_PX <- 20
require(DiceDesign)
x <- lhsDesign(nb_PX, d, seed = 123)$design
require(DiceKriging)
fx <- apply(x, 1, branin)
f <- ifelse(fx < 14, -1, 1)
Xf <- as.matrix(x)

## GPC model 
model <- gpcm(f, Xf, coef.m=0, coef.cov=c(0.5,0.5))

## print the result 
show(model)
}
\seealso{
\code{\link[=gpcm]{gpcm()}}
}
\author{
Morgane MENZ, Céline HELBERT, Victor PICHENY, François BACHOC. Contributors: Naoual SERRAJI.
}
