% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPmatching.R
\name{DPmatching}
\alias{DPmatching}
\title{calculate degree profile distances between two graphs and match nodes.}
\usage{
DPmatching(A, B, W = NULL)
}
\arguments{
\item{A, B}{Two 0/1 adjacency matrices.}

\item{W}{A distance matrix between \code{A} and \code{B}, which can be null.
If null, this function will calculate it. More details in
\emph{DPdistance}.}
}
\value{
\item{Dist}{The distance matrix between two graphs.} \item{match}{A
  vector containing matching results.}
}
\description{
This function constructs empirical distributions of degree
  profiles for each vertex and then calculate distances between each pair of
  vertices, one from graph \emph{A} and the other from graph \emph{B}. The
  default used is the 1-Wasserstein distance. This function also matches
  vertices in \emph{A} with vertices in \emph{B} via the distance matrix
  between \emph{A} and \emph{B}. The distance matrix can be null and
  \emph{DPmatching} will calculate it. \emph{A} and \emph{B} cannot be null
  when the distance matrix is null.
}
\examples{
set.seed(2020)
n = 10; q = 1/2; s = 1; p = 1
Parent = matrix(rbinom(n*n, 1, q), nrow = n, ncol = n)
Parent[lower.tri(Parent)] = t(Parent)[lower.tri(Parent)]
diag(Parent) <- 0
### Generate graph A
dA = matrix(rbinom(n*n, 1, s), nrow = n, ncol=n);
dA[lower.tri(dA)] = t(dA)[lower.tri(dA)]
A1 = Parent*dA
tmp = rbinom(n, 1, p)
n.A = length(which(tmp == 1))
indA = sample(1:n, n.A, replace = FALSE)
A = A1[indA, indA]
### Generate graph B
dB = matrix(rbinom(n*n, 1, s), nrow = n, ncol=n);
dB[lower.tri(dB)] = t(dB)[lower.tri(dB)]
B1 = Parent*dB
tmp = rbinom(n, 1, p)
n.B = length(which(tmp == 1))
indB = sample(1:n, n.B, replace = FALSE)
B = B1[indB, indB]
DPmatching(A, B)
W = DPdistance(A, B)
DPmatching(A, B, W)

}
