% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{lme.boots}
\alias{lme.boots}
\title{L-moment estimation with bootstrap standard errors}
\usage{
lme.boots(data, B = NULL, quant, boot = TRUE, trim = NULL)
}
\arguments{
\item{data}{Numeric vector of data.}

\item{B}{Number of bootstrap samples.}

\item{quant}{Numeric vector of probabilities for quantile estimation.}

\item{boot}{Logical. If TRUE (default), perform bootstrap.}

\item{trim}{Left trimming level for L-moments (integer). Default is NULL (0).}
}
\value{
A list containing:
\describe{
  \item{lme}{L-moment estimates (mu, sigma, xi)}
  \item{qua.lme}{Quantile estimates from LME}
  \item{quant}{Input quantile probabilities}
  \item{cov.par}{3x3 covariance of bootstrap parameter estimates (if boot=TRUE)}
  \item{cov.lambda}{3x3 covariance of bootstrap L-moments (if boot=TRUE)}
  \item{qua.lme.se}{SE of quantile estimates from bootstrap (if boot=TRUE)}
}
}
\description{
Internal function that computes L-moment estimates of GEV
parameters and optionally performs bootstrap resampling to obtain
covariance matrices and standard errors for quantile estimates.
}
\keyword{internal}
