% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{gev.max}
\alias{gev.max}
\title{MLE for GEV distribution using constrained optimization}
\usage{
gev.max(xdat, ntry = 5)
}
\arguments{
\item{xdat}{Numeric vector of data.}

\item{ntry}{Number of random starting points for optimization. Default is 5.}
}
\value{
A list containing:
\describe{
  \item{nsample}{Sample size}
  \item{conv}{Convergence status (0 = success)}
  \item{nllh}{Negative log-likelihood at the optimum}
  \item{mle}{MLE estimates (mu, sigma, xi) in Hosking style}
}
}
\description{
Internal function that computes maximum likelihood estimates
of GEV parameters using the Rsolnp constrained optimizer with multiple
random starting points.
}
\keyword{internal}
