% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{dist.noboot}
\alias{dist.noboot}
\title{Fit submodels and compute distance-based probabilities}
\usage{
dist.noboot(
  data = NULL,
  numk = NULL,
  hosking = NULL,
  boot.lme = TRUE,
  kpar = NULL,
  numom = NULL,
  ntry = 5,
  varcom = NULL,
  cov.lme = NULL,
  trim = NULL,
  cov.type = "lambda"
)
}
\arguments{
\item{data}{Numeric vector of data.}

\item{numk}{Number of candidate submodels.}

\item{hosking}{List containing LME results and bootstrap information.}

\item{boot.lme}{Logical. Whether bootstrap LME was performed (default TRUE).}

\item{kpar}{Numeric vector of candidate xi values.}

\item{numom}{Number of L-moments to use.}

\item{ntry}{Number of optimization attempts. Default is 5.}

\item{varcom}{Logical. Whether to compute variance.}

\item{cov.lme}{Pre-computed LME covariance (default NULL).}

\item{trim}{Left trimming level.}

\item{cov.type}{Covariance type: "ratio" or "lambda" (default "lambda").}
}
\value{
A list containing:
\describe{
  \item{aic}{AIC values for each submodel}
  \item{mle3}{Matrix (numk x 3) of submodel parameter estimates}
  \item{kfix}{List of submodel fitting results}
  \item{cov2}{List of 2x2 covariance matrices (if varcom=TRUE)}
  \item{prob.mtx}{Matrix (numk x 3) of distance-based probabilities}
  \item{gdd}{Matrix (numk x 2) of generalized distances}
}
}
\description{
Internal function that fits GEV submodels with fixed xi for
each candidate and computes generalized L-moment distance or median-based
probabilities for weight construction.
}
\keyword{internal}
