% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ajps.R
\docType{data}
\name{ajps}
\alias{ajps}
\title{Gaines and Kuklinski (2011) AJPS data}
\format{\describe{
  \item{tr}{The treatment indicator, where 1=treatment, 2=control, 3=chose treatment, 4=chose control.}
  \item{therm.obama}{A \dQuote{feeling thermometer} toward John McCain.}
  \item{therm.mccain}{A \dQuote{feeling thermometer} toward Barack Obama.}
  \item{pid}{An indicator of party identification, where -1=Republican, 0=Independent, 1=Democrat.}
}}
\source{
Brian J. Gaines and James H. Kuklinski, (2011), "Experimental Estimation of Heterogeneous Treatment Effects Related to Self-Selection," \emph{American Journal of Political Science} 55(3): 724-736.
}
\usage{
ajps
}
\description{
Subset of data from Gaines and Kuklinski (2011)
}
\details{
This dataset contains a subset of variables, extracted from the dataset used by Gaines and Kuklinski (2011).
}
\examples{
data(ajps)

# replicate Gaines and Kuklinski (2011) Table 2
pmean <- function(x) sprintf("\%0.1f", mean(x))
cbind(
  # Democrats
  aggregate(cbind(therm.mccain, therm.obama) ~ tr, 
            data = ajps[ajps$pid == 1, ], FUN = pmean)[, 1:3],
  n_dem = aggregate(therm.obama ~ tr, 
                    data = ajps[ajps$pid == 1, ], FUN = length)[, 2],
  # Republicans
  aggregate(cbind(therm.mccain, therm.obama) ~ tr, 
            data = ajps[ajps$pid == -1, ], FUN = pmean)[, 2:3],
  n_rep = aggregate(therm.obama ~ tr, 
                    data = ajps[ajps$pid == -1, ], FUN = length)[, 2]
)

# effects for McCain among Democrats
with(ajps[ajps$pid == 1, ], {
  estimate(rand = tr \%in\% 1:2, tr = tr \%in\% c(1,3), y = therm.mccain)
})
# effects for McCain among Republicans
with(ajps[ajps$pid == -1, ], {
  estimate(rand = tr \%in\% 1:2, tr = tr \%in\% c(1,3), y = therm.mccain)
})

# effects for Obama among Democrats
with(ajps[ajps$pid == 1, ], {
  estimate(rand = tr \%in\% 1:2, tr = tr \%in\% c(1,3), y = therm.obama)
})
# effects for Obama among Republicans
with(ajps[ajps$pid == -1, ], {
  estimate(rand = tr \%in\% 1:2, tr = tr \%in\% c(1,3), y = therm.obama)
})
}
\seealso{
\code{\link{estimate}}
}
\keyword{datasets}

