% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords_to_google.R
\encoding{UTF-8}
\name{coords_to_google}
\alias{coords_to_google}
\title{Convert coordinates to Google Maps}
\usage{
coords_to_google(coords, crs_out = 25833)
}
\arguments{
\item{coords}{An \code{sf} object with a geometry column that will be converted to \verb{CRS 4326}.}

\item{crs_out}{Chosen coordinate reference system (CRS) for the geometry column of the returned \code{sf} object.}
}
\value{
An \code{sf} object with a new column added (\code{coords_google}), and an addtional \code{sf} geometry column with the chosen CRS.
}
\description{
The function \code{coords_to_google} can be used to convert coordinates of an \code{sf} object to a format that is easy to copy and paste into Google Maps.
}
\examples{
address_to_coords(zip_code = "0185", address = "Schweigaards gate 10") \%>\%
  coords_to_google()

}
